/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.admin;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class OAuthApplicationOwnerUpdateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(OAuthApplicationOwnerUpdateTestCase.class);
    private UserManagementClient userManagementClient1 = null;
    private static final String USER_JOHN = "john1";
    private static final String USER_JOHN_PWD = "john1@";
    private static final String JOHN_APP = "johnApp";
    private static final String USER_MARY = "mary1";
    private static final String USER_MARY_PWD = "mary1@";
    private static final String MARY_APP = "maryApp";
    private static final String TENANT_ADMIN = "admin";
    private static final String TENANT_ADMIN_PWD = "admin1@";
    private static final String TENANT_USER1 = "user1";
    private static final String TENANT_USER1_PWD = "user1@";
    private static final String TENANT_USER1_APP = "user1App";
    private static final String TENANT_USER2 = "user2";
    private static final String TENANT_USER2_PWD = "user2@";
    private static final String TENANT_USER2_APP = "user2App";
    private static final String TENANT_USER3 = "user3";
    private static final String TENANT_USER3_PWD = "user3@";
    private static final String TENANT_USER3_APP = "user3App";
    private static final String TENANT_DOMAIN = "tenant.com";
    private static final String TENANT_ADMIN_WITH_DOMAIN = "admin@tenant.com";
    private static final String TENANT_ADMIN_APP = "tenantAdminApp";
    private static final String TENANT_USER1_WITH_DOMAIN = "user1@tenant.com";
    private static final String TENANT_USER2_WITH_DOMAIN = "user2@tenant.com";
    private static final String TENANT_USER3_WITH_DOMAIN = "user3@tenant.com";
    private static final String TENANT_USER4_WITH_DOMAIN = "user4@tenant.com";
    private String[] subscriberRole = new String[]{"Internal/subscriber"};
    private RestAPIStoreImpl restAPIStoreClient1;
    private RestAPIStoreImpl restAPIStoreClient2;
    private RestAPIStoreImpl restAPIStoreClient3;
    private RestAPIStoreImpl restAPIStoreClient4;
    private RestAPIStoreImpl restAPIStoreClient5;
    private RestAPIStoreImpl restAPIStoreClient6;
    private AdminDashboardRestClient adminDashboardRestClient;
    private JSONObject ownerJsonObject;
    private String appIdOfJohnApp;
    private String appIdOfMaryApp;
    private String appIdOfTenantAdminApp;
    private String appIdOfTenantUser1App;
    private String appIdOfTenantUser2App;
    private String appIdOfTenantUser3App;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.adminDashboardRestClient = new AdminDashboardRestClient(this.getPublisherURLHttps());
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient.addUser(USER_JOHN, USER_JOHN_PWD, this.subscriberRole, USER_JOHN);
        this.userManagementClient.addUser(USER_MARY, USER_MARY_PWD, this.subscriberRole, USER_MARY);
        this.tenantManagementServiceClient.addTenant(TENANT_DOMAIN, TENANT_ADMIN_PWD, TENANT_ADMIN, "demo");
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), TENANT_ADMIN_WITH_DOMAIN, TENANT_ADMIN_PWD);
        this.userManagementClient1.addUser(TENANT_USER1, TENANT_USER1_PWD, this.subscriberRole, TENANT_USER1);
        this.userManagementClient1.addUser(TENANT_USER2, TENANT_USER2_PWD, this.subscriberRole, TENANT_USER2);
        this.userManagementClient1.addUser(TENANT_USER3, TENANT_USER3_PWD, this.subscriberRole, TENANT_USER3);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.restAPIStoreClient1 = new RestAPIStoreImpl(USER_JOHN, USER_JOHN_PWD, "carbon.super", this.storeURLHttps);
        ApplicationDTO appOfJohnDTO = this.restAPIStoreClient1.addApplication(JOHN_APP, "Unlimited", "", "App of user John");
        this.appIdOfJohnApp = appOfJohnDTO.getApplicationId();
        this.restAPIStoreClient1.generateKeys(this.appIdOfJohnApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient2 = new RestAPIStoreImpl(USER_MARY, USER_MARY_PWD, "carbon.super", this.storeURLHttps);
        ApplicationDTO appOfMaryDTO = this.restAPIStoreClient2.addApplication(MARY_APP, "Unlimited", "", "App of user Mary");
        this.appIdOfMaryApp = appOfMaryDTO.getApplicationId();
        this.restAPIStoreClient2.generateKeys(this.appIdOfMaryApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient3 = new RestAPIStoreImpl(TENANT_ADMIN, TENANT_ADMIN_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantAdminDTO = this.restAPIStoreClient3.addApplication(TENANT_ADMIN_APP, "10PerMin", "", "App of tenant admin");
        this.appIdOfTenantAdminApp = appOfTenantAdminDTO.getApplicationId();
        this.restAPIStoreClient3.generateKeys(this.appIdOfTenantAdminApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient4 = new RestAPIStoreImpl(TENANT_USER1, TENANT_USER1_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantUser1DTO = this.restAPIStoreClient4.addApplication(TENANT_USER1_APP, "10PerMin", "", "App of tenant user 1");
        this.appIdOfTenantUser1App = appOfTenantUser1DTO.getApplicationId();
        this.restAPIStoreClient4.generateKeys(this.appIdOfTenantUser1App, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient5 = new RestAPIStoreImpl(TENANT_USER2, TENANT_USER2_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantUser2DTO = this.restAPIStoreClient5.addApplication(TENANT_USER2_APP, "10PerMin", "", "App of tenant user 2");
        this.appIdOfTenantUser2App = appOfTenantUser2DTO.getApplicationId();
        this.restAPIStoreClient5.generateKeys(this.appIdOfTenantUser2App, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient6 = new RestAPIStoreImpl(TENANT_USER3, TENANT_USER3_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantUser3DTO = this.restAPIStoreClient6.addApplication(TENANT_USER3_APP, "10PerMin", "", "App of tenant user 3");
        this.appIdOfTenantUser3App = appOfTenantUser3DTO.getApplicationId();
        this.restAPIStoreClient6.generateKeys(this.appIdOfTenantUser3App, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
    }

    @Test(groups={"wso2.am"}, description="Check whether the new owner is a valid subscriber")
    public void checkSubscriberValidity() throws Exception {
        this.adminDashboardRestClient.login(TENANT_ADMIN_WITH_DOMAIN, TENANT_ADMIN_PWD);
        this.updateOwner(TENANT_USER3_APP, TENANT_USER4_WITH_DOMAIN, TENANT_USER3_WITH_DOMAIN);
        Assert.assertTrue((boolean)this.ownerJsonObject.getBoolean("error"), (String)"user4@tenant.com is not a subscriber");
    }

    @Test(groups={"wso2.am"}, description="Update application ownership to a user from another tenant domain")
    public void updateApplicationOwnerAcrossTenant() throws Exception {
        this.adminDashboardRestClient.login(TENANT_ADMIN_WITH_DOMAIN, TENANT_ADMIN_PWD);
        this.updateOwner(TENANT_USER1_APP, USER_MARY, TENANT_USER1_WITH_DOMAIN);
        Assert.assertTrue((boolean)this.ownerJsonObject.getBoolean("error"), (String)"Unable to update application owner to the user mary1 as this user does not belong to this domain");
    }

    @Test(groups={"wso2.am"}, description="Check whether the new owner already has an application with that name")
    public void checkApplicationExist() throws Exception {
        this.adminDashboardRestClient.login(this.user.getUserName(), this.user.getPassword());
        this.updateOwner("DefaultApplication", USER_JOHN, USER_MARY);
        Assert.assertTrue((boolean)this.ownerJsonObject.getBoolean("error"), (String)"Unable to update application owner to the user john1 as this user already have a application with this name");
    }

    @Test(groups={"wso2.am"}, description="Update application ownership to another user within the same domain")
    public void updateApplicationOwner() throws Exception {
        this.adminDashboardRestClient.login(this.user.getUserName(), this.user.getPassword());
        this.updateOwner(MARY_APP, USER_JOHN, USER_MARY);
        Assert.assertFalse((boolean)this.ownerJsonObject.getBoolean("error"), (String)"Successfully update owner of the application maryApp.");
        this.adminDashboardRestClient.login(TENANT_ADMIN_WITH_DOMAIN, TENANT_ADMIN_PWD);
        this.updateOwner(TENANT_USER2_APP, TENANT_USER1_WITH_DOMAIN, TENANT_USER2_WITH_DOMAIN);
        Assert.assertFalse((boolean)this.ownerJsonObject.getBoolean("error"), (String)"Successfully update owner of the application user2App.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStoreClient1.deleteApplication(this.appIdOfJohnApp);
        this.restAPIStoreClient2.deleteApplication(this.appIdOfMaryApp);
        this.restAPIStoreClient3.deleteApplication(this.appIdOfTenantAdminApp);
        this.restAPIStoreClient4.deleteApplication(this.appIdOfTenantUser1App);
        this.restAPIStoreClient5.deleteApplication(this.appIdOfTenantUser2App);
        this.restAPIStoreClient6.deleteApplication(this.appIdOfTenantUser3App);
        if (this.userManagementClient != null) {
            this.userManagementClient.deleteUser(USER_JOHN);
            this.userManagementClient.deleteUser(USER_MARY);
        }
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser(TENANT_USER1);
            this.userManagementClient1.deleteUser(TENANT_USER2);
            this.userManagementClient1.deleteUser(TENANT_USER3);
        }
        this.tenantManagementServiceClient.deleteTenant(TENANT_DOMAIN);
    }

    private void updateOwner(String application, String userId, String owner) throws Exception {
        int i;
        HttpResponse tenantApplications = this.adminDashboardRestClient.getapplicationsByTenantId(application, "0", "0", "20", "1", "asc");
        this.log.info((Object)("Application: " + application));
        this.log.info((Object)("Old User: " + owner));
        this.log.info((Object)("New User: " + userId));
        this.log.info((Object)("Data for getapplicationsByTenantId: " + tenantApplications.getData()));
        JSONObject jsonObject = new JSONObject(tenantApplications.getData());
        JSONArray jsonArray = jsonObject.getJSONArray("response");
        for (i = 0; i < jsonArray.length(); ++i) {
            if (!owner.equals(jsonArray.getJSONObject(i).getString("owner"))) continue;
            String uuid = jsonArray.getJSONObject(i).getString("uuid");
            HttpResponse response = this.adminDashboardRestClient.updateApplicationOwner(userId, owner, uuid, application);
            this.ownerJsonObject = new JSONObject(response.getData());
            break;
        }
        this.log.info((Object)("Owner JSON Object before IF: " + this.ownerJsonObject));
        if (!this.ownerJsonObject.getBoolean("error")) {
            HttpResponse updatedApplications = this.adminDashboardRestClient.getapplicationsByTenantId(application, "0", "0", "10", "1", "asc");
            JSONObject jsonObject1 = new JSONObject(updatedApplications.getData());
            JSONArray jsonArray1 = jsonObject1.getJSONArray("response");
            String ownerApp = jsonArray1.getJSONObject(i).getString("owner");
            Assert.assertEquals((String)ownerApp, (String)userId);
        }
    }
}

