/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APISecurityTestCase
extends APIManagerLifecycleBaseTest {
    private final String mutualSSLOnlyAPIName = "mutualsslOnlyAPI";
    private final String mutualSSLWithOAuthAPI = "mutualSSLWithOAuthAPI";
    private final String mutualSSLandOauthMandatoryAPI = "mutualSSLandOAuthMandatoryAPI";
    private final String mutualSSLOnlyAPIContext = "mutualsslOnlyAPI";
    private final String mutualSSLWithOAuthAPIContext = "mutualSSLWithOAuthAPI";
    private final String mutualSSLandOAuthMandatoryAPIContext = "mutualSSLandOAuthMandatoryAPI";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase";
    private String accessToken;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String applicationId;
    private String apiId1;
    private String apiId2;
    private String apiId3;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, IOException, org.wso2.am.integration.clients.publisher.api.ApiException, ApiException, XPathExpressionException, AutomationUtilException, InterruptedException {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest1 = new APIRequest("mutualsslOnlyAPI", "mutualsslOnlyAPI", new URL(this.apiEndPointUrl));
        apiRequest1.setVersion("1.0.0");
        apiRequest1.setTiersCollection("Unlimited");
        apiRequest1.setTier("Unlimited");
        apiRequest1.setTags("testTag1, testTag2, testTag3");
        apiRequest1.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/customers/{id}");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        apiRequest1.setOperationsDTOS(operationsDTOS);
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("mutualssl");
        securitySchemes.add("mutualssl_mandatory");
        apiRequest1.setSecurityScheme(securitySchemes);
        apiRequest1.setDefault_version("true");
        apiRequest1.setHttps_checked("https");
        apiRequest1.setHttp_checked(null);
        apiRequest1.setDefault_version_checked("true");
        HttpResponse response1 = this.restAPIPublisher.addAPI(apiRequest1);
        this.apiId1 = response1.getData();
        String certOne = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certOne), "example", this.apiId1, "Unlimited");
        APIRequest apiRequest2 = new APIRequest("mutualSSLWithOAuthAPI", "mutualSSLWithOAuthAPI", new URL(this.apiEndPointUrl));
        apiRequest2.setVersion("1.0.0");
        apiRequest2.setTiersCollection("Unlimited");
        apiRequest2.setTier("Unlimited");
        apiRequest2.setTags("testTag1, testTag2, testTag3");
        apiRequest2.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest2.setOperationsDTOS(operationsDTOS);
        apiRequest2.setDefault_version("true");
        apiRequest2.setHttps_checked("https");
        apiRequest2.setHttp_checked(null);
        apiRequest2.setDefault_version_checked("true");
        ArrayList<String> securitySchemes2 = new ArrayList<String>();
        securitySchemes2.add("mutualssl");
        securitySchemes2.add("oauth2");
        securitySchemes2.add("api_key");
        securitySchemes2.add("oauth_basic_auth_api_key_mandatory");
        apiRequest2.setSecurityScheme(securitySchemes2);
        HttpResponse response2 = this.restAPIPublisher.addAPI(apiRequest2);
        this.apiId2 = response2.getData();
        String certTwo = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certTwo), "abcde", this.apiId2, "Unlimited");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId1, APILifeCycleAction.PUBLISH.getAction());
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId2, APILifeCycleAction.PUBLISH.getAction());
        APIRequest apiRequest3 = new APIRequest("mutualSSLandOAuthMandatoryAPI", "mutualSSLandOAuthMandatoryAPI", new URL(this.apiEndPointUrl));
        apiRequest3.setVersion("1.0.0");
        apiRequest3.setTiersCollection("Unlimited");
        apiRequest3.setTier("Unlimited");
        apiRequest3.setTags("testTag1, testTag2, testTag3");
        apiRequest3.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest3.setOperationsDTOS(operationsDTOS);
        ArrayList<String> securitySchemes3 = new ArrayList<String>();
        securitySchemes3.add("mutualssl");
        securitySchemes3.add("oauth2");
        securitySchemes3.add("api_key");
        securitySchemes3.add("mutualssl_mandatory");
        securitySchemes3.add("oauth_basic_auth_api_key_mandatory");
        apiRequest3.setSecurityScheme(securitySchemes3);
        apiRequest3.setDefault_version("true");
        apiRequest3.setHttps_checked("https");
        apiRequest3.setHttp_checked(null);
        apiRequest3.setDefault_version_checked("true");
        HttpResponse response3 = this.restAPIPublisher.addAPI(apiRequest3);
        this.apiId3 = response3.getData();
        String certThree = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certThree), "abcdef", this.apiId3, "Unlimited");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId3, APILifeCycleAction.PUBLISH.getAction());
        HttpResponse applicationResponse = this.restAPIStore.createApplication("AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(this.apiId3, this.applicationId, "Unlimited");
        this.restAPIStore.subscribeToAPI(this.apiId2, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        Thread.sleep(120000L);
    }

    @Test(description="This test case tests the behaviour of APIs that are protected with mutual SSL and OAuth2 when the client certificate is not presented but OAuth2 token is presented.")
    public void testCreateAndPublishAPIWithOAuth2() throws XPathExpressionException, IOException, JSONException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI", "1.0.0") + "/customers/123"), requestHeaders);
        JSONObject response = new JSONObject(apiResponse.getData());
        Assert.assertEquals((int)response.getJSONObject("fault").getInt("code"), (int)900901, (String)"API invocation succeeded with the access token without need for mutual ssl");
        apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API invocation failed for a test case with valid access token when the API is protected with both mutual sso and oauth2");
    }

    @Test(description="Testing the invocation with API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithApiKeys() throws Exception {
        APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200);
    }

    @Test(description="Invoke mutual SSL only API with not supported certificate", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLOnlyAPINegative() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401);
    }

    @Test(description="This method test to validate how application security mandatory and mutual ssl optional api behaviour in success scenario", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatory() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="Test with no application security header with valid cert", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatoryNegative1() throws IOException, XPathExpressionException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual authentication success for oauth mandatory scenario");
    }

    @Test(description="This method test to validate how application security mandatory and mutual ssl optional api behaviour in success scenario", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatoryNegative2() throws IOException, XPathExpressionException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Mutual authentication success for oauth mandatory scenario");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200, (String)"Mutual authentication success for oauth mandatory scenario");
    }

    @Test(description="This method test to validate how application security mandatory and mutual ssl optional api behaviour in success scenario", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatoryNegative3() throws IOException, XPathExpressionException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + UUID.randomUUID().toString());
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual authentication success for oauth mandatory scenario");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual authentication success for oauth mandatory scenario");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLMandatory() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has not succeed");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has not succeed");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLMandatoryNeagative1() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLMandatoryNegative2() throws IOException, XPathExpressionException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLHeader() throws IOException, XPathExpressionException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        requestHeaders.put("X-WSO2-CLIENT-CERTIFICATE", this.generateBase64EncodedCertificate());
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws IOException, AutomationUtilException, org.wso2.am.integration.clients.publisher.api.ApiException {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId1);
        this.restAPIPublisher.deleteAPI(this.apiId2);
        this.restAPIPublisher.deleteAPI(this.apiId3);
    }

    public String generateBase64EncodedCertificate() throws IOException {
        String certOne = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        String base64EncodedString = IOUtils.toString((InputStream)new FileInputStream(certOne));
        base64EncodedString = Base64.encodeBase64URLSafeString((byte[])base64EncodedString.getBytes());
        return base64EncodedString;
    }
}

