/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;

public class APIVisibilityByPublicTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIVisibilityByPublicTestCase.class);
    private final String API_NAME = "APIVisibilityByPublicTest";
    private final String API_CONTEXT = "APIVisibilityByPublic";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String CARBON_SUPER_TENANT2_KEY = "userKey2";
    private final String EMAIL_USER_KEY = "emailUser";
    private final String EMAIL_USER2_KEY = "emailUser2";
    private final String EMAIL_USER3_KEY = "emailUser3";
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String USER_KEY_USER2 = "userKey1";
    private final String OTHER_DOMAIN_TENANT_USER_KEY = "user1";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String AT = "@";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private String apiID;
    private RestAPIStoreImpl apiStoreClientAnotherUserSameDomain;
    private RestAPIPublisherImpl apiPublisherClientUserAnotherUserSameDomain;
    private RestAPIStoreImpl apiStoreClientAnotherUserOtherDomain;
    private RestAPIPublisherImpl apiPublisherClientAnotherUserOtherDomain;
    private RestAPIStoreImpl apiStoreClientAdminOtherDomain;
    private RestAPIPublisherImpl apiPublisherClientAdminOtherDomain;
    private String providerName;
    private RestAPIPublisherImpl apiPublisherClientUser2;
    private RestAPIStoreImpl apiStoreClientUser2;
    private RestAPIPublisherImpl apiPublisherClientUser1;
    private RestAPIStoreImpl apiStoreClientUser1;
    private String otherDomain;
    private String apiCreatorStoreDomain;
    private String storeURLHttp;
    private User user2;
    private User user3;
    private User otherDomainUser2;

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_EMAIL_USER}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public APIVisibilityByPublicTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException {
        String username3;
        String username2;
        super.init(this.userMode);
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new RestAPIPublisherImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.publisherURLHttps);
        this.apiStoreClientUser1 = new RestAPIStoreImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.storeURLHttps);
        this.apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.user2 = this.publisherContext.getContextTenant().getTenantUser("userKey1");
            this.user3 = this.publisherContext.getContextTenant().getTenantUser("userKey2");
            username2 = this.user2.getUserNameWithoutDomain();
            username3 = this.user3.getUserNameWithoutDomain();
            this.providerName = this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName();
        } else {
            this.user2 = this.publisherContext.getContextTenant().getTenantUser("emailUser2");
            this.user3 = this.publisherContext.getContextTenant().getTenantUser("emailUser3");
            username2 = this.user2.getUserName();
            username3 = this.user3.getUserName();
            this.providerName = this.publisherContext.getContextTenant().getTenantUser("emailUser2").getUserName() + "@" + this.apiCreatorStoreDomain;
        }
        this.apiPublisherClientUser2 = new RestAPIPublisherImpl(username2, this.user2.getPassword(), this.apiCreatorStoreDomain, this.publisherURLHttps);
        this.apiStoreClientUser2 = new RestAPIStoreImpl(username2, this.user2.getPassword(), this.apiCreatorStoreDomain, this.storeURLHttps);
        this.apiStoreClientAnotherUserSameDomain = new RestAPIStoreImpl(username3, this.user3.getPassword(), this.apiCreatorStoreDomain, this.storeURLHttps);
        this.apiPublisherClientUserAnotherUserSameDomain = new RestAPIPublisherImpl(username3, this.user3.getPassword(), this.apiCreatorStoreDomain, this.publisherURLHttps);
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.init("wso2.com", "admin");
            this.otherDomainUser2 = this.storeContext.getContextTenant().getTenantUser("user1");
        } else {
            this.init("wso2.com", "emailUser");
            this.otherDomainUser2 = this.storeContext.getContextTenant().getTenantUser("emailUser2");
        }
        this.otherDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientAnotherUserOtherDomain = new RestAPIStoreImpl(this.otherDomainUser2.getUserNameWithoutDomain(), this.otherDomainUser2.getPassword(), this.otherDomain, this.publisherURLHttps);
        this.apiPublisherClientAnotherUserOtherDomain = new RestAPIPublisherImpl(this.otherDomainUser2.getUserNameWithoutDomain(), this.otherDomainUser2.getPassword(), this.otherDomain, this.publisherURLHttps);
        this.apiStoreClientAdminOtherDomain = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getContextUser().getUserDomain(), this.publisherURLHttps);
        this.apiPublisherClientAdminOtherDomain = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getContextUser().getUserDomain(), this.publisherURLHttps);
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for API creator ")
    public void testVisibilityForCreatorInPublisher() throws Exception {
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByPublicTest", "1.0.0");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIVisibilityByPublicTest", "APIVisibilityByPublic", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        APIDTO apidto = this.apiPublisherClientUser2.addAPI(apiCreationRequestBean);
        this.apiID = apidto.getId();
        this.publishAPI(this.apiID, this.apiPublisherClientUser2, false);
        for (int retry = 0; retry < 15; ++retry) {
            List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientUser2.getAllAPIs());
            if (APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList)) {
                this.log.info((Object)"API 'APIVisibilityByPublicTest' is available on store.");
                break;
            }
            this.log.info((Object)"Waiting for API 'APIVisibilityByPublicTest' is available on store.");
            Thread.sleep(1000L);
        }
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientUser2.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to creator in APi Publisher. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for API creator", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForCreatorInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientUser2.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to creator in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in same domain ", dependsOnMethods={"testVisibilityForCreatorInStore"})
    public void testVisibilityForAdminInSameDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientUser1.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to admin in same domain in API Publisher. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in same domain ", dependsOnMethods={"testVisibilityForAdminInSameDomainInPublisher"})
    public void testVisibilityForAdminInSameDomainInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientUser1.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to admin in same domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in same domain", dependsOnMethods={"testVisibilityForAdminInSameDomainInStore"})
    public void testVisibilityForAnotherUserInSameDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientUserAnotherUserSameDomain.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to another user in same domain in API Publisher. When Visibility is public." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInPublisher"})
    public void testVisibilityForAnotherUserInSameDomainInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAnotherUserSameDomain.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to another user in same domain in API Store. When Visibility is public." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInStore"})
    public void testVisibilityForAnotherUserInOtherDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is  visible to another user in other domain in API Publisher. When Visibility is public." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInPublisher"})
    public void testVisibilityForAnotherUserInOtherDomainInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to another user in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInStore"})
    public void testVisibilityForAdminInOtherDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)this.apiPublisherClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is  visible to admin in other domain in API Publisher. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in other domain", dependsOnMethods={"testVisibilityForAdminInOtherDomainInPublisher"})
    public void testVisibilityForAdminInOtherDomainInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to admin in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in other domainStore for anonymous user", dependsOnMethods={"testVisibilityForAdminInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInOtherDomainInStore() throws Exception {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAdminOtherDomain.getAPIListFromStoreAsAnonymousUser(this.otherDomain));
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to admin in other domain in API Store. When Visibility is public. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in Same domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnonymousUserInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInSameDomainInStore() throws Exception {
        long currentTime;
        long maxLookupTime = 60000L;
        boolean apiFound = false;
        long startTime = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.log.warn((Object)"InterruptedException occurs while sleeping 500 milliseconds", (Throwable)e);
            }
            currentTime = System.currentTimeMillis();
            List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.apiStoreClientAdminOtherDomain.getAPIListFromStoreAsAnonymousUser(this.apiCreatorStoreDomain));
            if (APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList)) {
                apiFound = true;
                break;
            }
            this.log.info((Object)("APIVisibilityByPublicTest API is not visible for anonymous user in same domain in store after :" + (currentTime - startTime) + " milliseconds"));
        } while (currentTime - startTime < maxLookupTime);
        Assert.assertTrue((boolean)apiFound, (String)("API is not visible to anonymous user in same domain API Store After " + (currentTime - startTime) + " milliseconds. When Visibility is public.  " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException, ApiException {
        this.deleteAPI(this.apiID, this.apiPublisherClientUser1);
    }
}

