/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "CopyAPIWithOutReSubscriptionTest";
    private final String API_CONTEXT = "CopyAPIWithOutReSubscription";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_VERSION_2_0_0 = "2.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private String applicationId;
    private String apiId;
    private String newApiId;
    private APIRequest apiRequest;
    private Map<String, String> requestHeaders;
    private ArrayList<String> grantTypes;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.grantTypes = new ArrayList();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiRequest = new APIRequest("CopyAPIWithOutReSubscriptionTest", "CopyAPIWithOutReSubscription", new URL(this.apiEndPointUrl));
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTier("Unlimited");
        this.apiRequest.setProvider(this.providerName);
        this.apiRequest.setTags("testTag1, testTag2, testTag3");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("AccessibilityOfOldAPIAndCopyAPIWithOutReSubscriptionTestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old api version.")
    public void testSubscriptionOfOldAPI() throws APIManagerIntegrationTestException, XPathExpressionException {
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Unlimited", this.restAPIStore);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)oldVersionSubscribeResponse.getData()), (String)("Error in subscribe of old API version" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
    }

    @Test(groups={"wso2.am"}, description="Test publishing of copied API with out re-subscription required", dependsOnMethods={"testSubscriptionOfOldAPI"})
    public void testPublishCopiedAPIWithOutReSubscriptionRequired() throws Exception {
        this.apiRequest.setVersion("2.0.0");
        HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI("2.0.0", this.apiId, null);
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        this.newApiId = newVersionResponse.getData();
        HttpResponse publishAPIResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.newApiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)APILifeCycleState.PUBLISHED.getState().equals(publishAPIResponse.getData()), (String)("API status Change is invalid when retire an API :CopyAPIWithOutReSubscriptionTest with API ID (" + this.apiId + ") Response Code:" + publishAPIResponse.getResponseCode()));
    }

    @Test(groups={"wso2.am"}, description="Test invocation of new API version before the new version is subscribed.", dependsOnMethods={"testPublishCopiedAPIWithOutReSubscriptionRequired"})
    public void testInvokeNewAPIWithoutSubscribeTheNewVersion() throws Exception {
        this.waitForAPIDeploymentSync(this.user.getUserName(), "CopyAPIWithOutReSubscriptionTest", "2.0.0", "\"isApiExists\":true");
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("CopyAPIWithOutReSubscription", "2.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke new api before subscribe the new version when re-subscription is not required.");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke new API version before subscribe the new version whenre-subscription is not required. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO.getSubscriptionId());
        }
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newApiId);
        super.cleanUp();
    }
}

