/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeAPIEndPointURLTestCase
extends APIManagerLifecycleBaseTest {
    private final String API1_END_POINT_METHOD = "/customers/123";
    private final String API1_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String INVOKABLE_API_CONTEXT = "1.0.0/api";
    private final String API2_RESPONSE_DATA = "HelloWSO2";
    private final String API2_END_POINT_POSTFIX_URL = "name-check1_SB/name";
    private String api2EndPointUrl;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private Map<String, String> requestHeaders;

    @BeforeClass(alwaysRun=true)
    public void initialize(ITestContext ctx) throws APIManagerIntegrationTestException {
        super.init();
        this.providerName = this.user.getUserName();
        this.apiIdentifier = new APIIdentifier(this.providerName, "APITest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Test  invocation of API before change the  api end point URL.")
    public void testAPIInvocationBeforeChangeTheEndPointURL(ITestContext ctx) throws Exception {
        String accessToken = (String)ctx.getAttribute("accessToken");
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "*/*");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before change the end point URL");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before change the end point URL Response Data:" + oldVersionInvokeResponse.getData() + ". Expected Response Data: " + "<id>123</id><name>John</name></Customer>"));
    }

    @Test(groups={"wso2.am"}, description="Test changing of the API end point URL", dependsOnMethods={"testAPIInvocationBeforeChangeTheEndPointURL"})
    public void testEditEndPointURL(ITestContext ctx) throws ApiException, ParseException {
        String apiId = (String)ctx.getAttribute("apiId");
        HttpResponse response = this.restAPIPublisher.getAPI(apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + this.backEndServerUrl.getWebAppURLHttp() + "name-check1_SB/name" + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + this.backEndServerUrl.getWebAppURLHttp() + "name-check1_SB/name" + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"http\"\n}";
        JSONParser parser = new JSONParser();
        JSONObject endpoint = (JSONObject)parser.parse(endPointString);
        apidto.setEndpointConfig((Object)endpoint);
        APIDTO updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apidto, apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateAPIHTTPResponse.getId()), (String)("Update API end point URL Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        this.waitForAPIDeployment();
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of API using new end point URL  after end point URL  change", dependsOnMethods={"testEditEndPointURL"})
    public void testInvokeAPIAfterChangeAPIEndPointURLWithNewEndPointURL() throws Exception {
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("1.0.0/api"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke  API  after change the end point URL");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("HelloWSO2"), (String)("Response data mismatched when invoke  API  after change the end point URL Response Data:" + oldVersionInvokeResponse.getData() + ". Expected Response Data: " + "HelloWSO2"));
        Assert.assertFalse((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  after change the end point URL. It contains the Old end point URL response data. Response Data:" + oldVersionInvokeResponse.getData() + ". Expected Response Data: " + "HelloWSO2"));
    }
}

