/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeAPITagsTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeAPITagsTestCaseAPI";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String OLD_TAGS = "Tag1, Tag2, Tag3";
    private final String NEW_TAGS = "Tag1, Tag2";
    private final String TEST_TAG = "Tag3";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private String apiId;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest = new APIRequest("ChangeAPITagsTestCaseAPI", "ChangeAPITagsTestCaseAPI".toLowerCase(), new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.providerName);
        apiRequest.setDescription("This is test API create by API manager integration test");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags("Tag1, Tag2, Tag3");
        this.apiId = this.createAndPublishAPIWithoutRequireReSubscriptionUsingRest(apiRequest, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test the filter by Tags before changing the Tags")
    public void testFilterByTagsBeforeTagChange() throws APIManagerIntegrationTestException, ApiException, InterruptedException {
        boolean isAvailable = false;
        int maxRetry = 10;
        int currentTry = 0;
        do {
            Thread.sleep(2000L);
            APIListDTO apiFilteredWithTagsDTOs = this.restAPIStore.getAPIsFilteredWithTags("Tag3");
            if (apiFilteredWithTagsDTOs == null) continue;
            isAvailable = true;
            break;
        } while (++currentTry <= maxRetry);
        Assert.assertTrue((boolean)isAvailable, (String)"API: ChangeAPITagsTestCaseAPI is not visible for tag: Tag3");
    }

    @Test(groups={"wso2.am"}, description="Test the filter by Tags After changing the Tags", dependsOnMethods={"testFilterByTagsBeforeTagChange"})
    public void testUpdateTagsAndFilterByTags() throws Exception {
        APIRequest apiRequest = new APIRequest("ChangeAPITagsTestCaseAPI", "ChangeAPITagsTestCaseAPI".toLowerCase(), new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.providerName);
        apiRequest.setDescription("This is test API create by API manager integration test");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags("Tag1, Tag2");
        HttpResponse updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apiRequest, this.apiId);
        this.waitForAPIDeployment();
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update API Response Code is invalid. API Name:ChangeAPITagsTestCaseAPI");
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateAPIHTTPResponse.getData()), (String)"Error in API Update in API Name:ChangeAPITagsTestCaseAPI");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        APIListDTO apiFilteredWithTagsDTOs = this.restAPIStore.getAPIsFilteredWithTags("Tag3");
        Assert.assertTrue((apiFilteredWithTagsDTOs == null ? 1 : 0) != 0, (String)"API: ChangeAPITagsTestCaseAPI is visible for tag: Tag3");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

