/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIEndpointSecurityDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeEndPointSecurityOfAPITestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ChangeEndPointSecurityOfAPITestCase.class);
    private final String API_NAME = "ChangeEndPointSecurityOfAPITest";
    private final String API_CONTEXT = "ChangeEndPointSecurityOfAPI";
    private final String API_TAGS = "security, username, password";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeEndPointSecurityOfAPI";
    private HashMap<String, String> requestHeadersGet;
    private String providerName;
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private String applicationID;
    private String apiID;

    @Factory(dataProvider="userModeDataProvider")
    public ChangeEndPointSecurityOfAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/plain");
        this.requestHeadersGet.put("Content-Type", "text/plain");
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeEndPointSecurityOfAPITest", "1.0.0");
        ApplicationDTO dto = this.restAPIStore.addApplication("ChangeEndPointSecurityOfAPI", "Unlimited", "", "");
        this.applicationID = dto.getApplicationId();
    }

    @Test(groups={"wso2.am"}, description="Test the API with endpoint security enabled with simple password that only has characters and numbers")
    public void testInvokeGETResourceWithSecuredEndPointPasswordOnlyNumbersAndLetters() throws Exception {
        String endpointUsername = "admin1";
        char[] endpointPassword = new char[]{'a', 'd', 'm', 'i', 'n', '1', '2', '3'};
        byte[] userNamePasswordByteArray = (endpointUsername + ":" + String.valueOf(endpointPassword)).getBytes();
        String encodedUserNamePassword = DatatypeConverter.printBase64Binary((byte[])userNamePasswordByteArray);
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeEndPointSecurityOfAPITest", "ChangeEndPointSecurityOfAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("security, username, password");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setEndpointType(APIEndpointSecurityDTO.TypeEnum.BASIC.getValue());
        apiCreationRequestBean.setEpUsername(endpointUsername);
        apiCreationRequestBean.setEpPassword(String.valueOf(endpointPassword));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "ChangeEndPointSecurityOfAPITest", "1.0.0");
        apiIdentifier.setTier("Unlimited");
        APIDTO apidto = this.createPublishAndSubscribeToAPI(apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiID = apidto.getId();
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityOfAPITest", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.requestHeadersGet.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeEndPointSecurityOfAPI", "1.0.0") + "/sec"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Invocation fails for GET request for endpoint type secured. username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
        Assert.assertTrue((boolean)httpResponseGet.getData().contains(encodedUserNamePassword), (String)("Response Data not match for GET request for endpoint type secured. Expected value :" + encodedUserNamePassword + " not contains in response data:" + httpResponseGet.getData() + "username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
    }

    @Test(groups={"wso2.am"}, description="Test the API with endpoint security enabled with complex password", dependsOnMethods={"testInvokeGETResourceWithSecuredEndPointPasswordOnlyNumbersAndLetters"})
    public void testInvokeGETResourceWithSecuredEndPointComplexPassword() throws Exception {
        char[] symbolicCharacter = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '-', '+', '=', '{', '[', '}', ']', '|', '\\', ':', ';', '\"', '\'', '<', ',', '>', '.', '?', '/'};
        APIDTO apidto = this.restAPIPublisher.getAPIByID(this.apiID, this.user.getUserDomain());
        block0: for (int i = 0; i < symbolicCharacter.length; ++i) {
            String endpointUsername = "user";
            char[] endpointPassword = new char[]{'a', 'b', 'c', 'd', symbolicCharacter[i], 'e', 'f', 'g', 'h', 'i', 'j', 'k'};
            byte[] userNamePasswordByteArray = (endpointUsername + ":" + String.valueOf(endpointPassword)).getBytes();
            String encodedUserNamePassword = DatatypeConverter.printBase64Binary((byte[])userNamePasswordByteArray);
            APIEndpointSecurityDTO securityDTO = apidto.getEndpointSecurity();
            securityDTO.setUsername(endpointUsername);
            securityDTO.setPassword(String.valueOf(endpointPassword));
            apidto.setEndpointSecurity(securityDTO);
            this.restAPIPublisher.updateAPI(apidto);
            this.waitForAPIDeployment();
            int retries = 3;
            for (int j = 0; j <= retries; ++j) {
                HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeEndPointSecurityOfAPI", "1.0.0") + "/sec"), this.requestHeadersGet);
                Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Invocation fails for GET request for endpoint type secured. username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
                if (httpResponseGet.getData().contains(encodedUserNamePassword)) {
                    Assert.assertTrue((boolean)true);
                    continue block0;
                }
                if (j == retries) {
                    log.error((Object)"Max retry count reached!!!");
                    Assert.fail((String)("Response Data not match for GET request for endpoint type secured. Expected value : " + encodedUserNamePassword + " not contains in response data: " + httpResponseGet.getData() + " username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
                    continue;
                }
                log.warn((Object)("[Warning] Response Data not match for GET request for endpoint type secured. Expected value : " + encodedUserNamePassword + " not contains in response data: " + httpResponseGet.getData() + " username:" + endpointUsername + " password:" + String.valueOf(endpointPassword) + " Retrying..."));
                this.waitForAPIDeployment();
            }
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.removeApplicationById(this.applicationID);
        this.restAPIPublisher.deleteAPIByID(this.apiID);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

