/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIEndpointSecurityDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import waffle.util.Base64;

public class ChangeEndPointSecurityPerTypeTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ChangeEndPointSecurityPerTypeTestCase.class);
    private final String API_NAME = "ChangeEndPointSecurityPerTypeTestCase";
    private final String API_CONTEXT = "ChangeEndPointSecurityPerTypeTestCase";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeEndPointSecurityPerTypeTestCase";
    private HashMap<String, String> requestHeadersGet;
    private String providerName;
    private String apiEndPointUrl;
    private String applicationID;
    private String apiID;
    private ApplicationKeyDTO productionApplication;
    private ApplicationKeyDTO sandboxApplication;
    String endpointUsername = "admin";
    String endpointPassword = "admin123";

    @Factory(dataProvider="userModeDataProvider")
    public ChangeEndPointSecurityPerTypeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getAPIInvocationURLHttp("backendSecurity") + "/1.0.0";
        this.providerName = this.user.getUserName();
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/plain");
        this.requestHeadersGet.put("Content-Type", "text/plain");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "ChangeEndPointSecurityPerTypeTestCase", "1.0.0");
        ApplicationDTO dto = this.restAPIStore.addApplicationWithTokenType("ChangeEndPointSecurityPerTypeTestCase", "Unlimited", "", "", ApplicationDTO.TokenTypeEnum.OAUTH.getValue());
        this.applicationID = dto.getApplicationId();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeEndPointSecurityPerTypeTestCase", "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setEndpointType(APIEndpointSecurityDTO.TypeEnum.BASIC.getValue());
        apiCreationRequestBean.setEpUsername(this.endpointUsername);
        apiCreationRequestBean.setEpPassword(this.endpointPassword);
        apiIdentifier.setTier("Unlimited");
        APIDTO apidto = this.createPublishAndSubscribeToAPI(apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiID = apidto.getId();
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.productionApplication = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.sandboxApplication = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security")
    public void testEndpointSecurityInGlobal() throws Exception {
        this.requestHeadersGet.put("Authorization", "Bearer " + this.productionApplication.getToken().getAccessToken());
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])this.endpointUsername.concat(":").concat(this.endpointPassword).getBytes())));
        this.requestHeadersGet.put("Authorization", "Bearer " + this.sandboxApplication.getToken().getAccessToken());
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])this.endpointUsername.concat(":").concat(this.endpointPassword).getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testEndpointSecurityInGlobal"})
    public void testEndpointSecurityInGlobalUpdatingAPI() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        Assert.assertNotNull((Object)apidto.getEndpointSecurity());
        APIEndpointSecurityDTO endpointSecurity = apidto.getEndpointSecurity();
        Assert.assertEquals((String)endpointSecurity.getPassword(), (String)"");
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        APIEndpointSecurityDTO updatedEndpointSecurity = updatedAPI.getEndpointSecurity();
        Assert.assertEquals((String)updatedEndpointSecurity.getPassword(), (String)"");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        this.requestHeadersGet.put("Authorization", "Bearer " + this.productionApplication.getToken().getAccessToken());
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])this.endpointUsername.concat(":").concat(this.endpointPassword).getBytes())));
        this.requestHeadersGet.put("Authorization", "Bearer " + this.sandboxApplication.getToken().getAccessToken());
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])this.endpointUsername.concat(":").concat(this.endpointPassword).getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testEndpointSecurityInGlobalUpdatingAPI"})
    public void testUpdateEndpointSecurityForGlobal() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        Assert.assertNotNull((Object)apidto.getEndpointSecurity());
        APIEndpointSecurityDTO endpointSecurity = apidto.getEndpointSecurity();
        Assert.assertEquals((String)endpointSecurity.getPassword(), (String)"");
        endpointSecurity.setPassword("wso2carbon");
        apidto.setEndpointSecurity(endpointSecurity);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        APIEndpointSecurityDTO updatedEndpointSecurity = updatedAPI.getEndpointSecurity();
        Assert.assertEquals((String)updatedEndpointSecurity.getPassword(), (String)"");
        this.requestHeadersGet.put("Authorization", "Bearer " + this.productionApplication.getToken().getAccessToken());
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])this.endpointUsername.concat(":").concat("wso2carbon").getBytes())));
        this.requestHeadersGet.put("Authorization", "Bearer " + this.sandboxApplication.getToken().getAccessToken());
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])this.endpointUsername.concat(":").concat("wso2carbon").getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testEndpointSecurityInGlobalUpdatingAPI"})
    public void testUpdateEndpointSecurityForProduction() throws Exception {
        String productionEndpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"admin1234\",\n    \"password\":\"admin123#QA\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        apidto.setEndpointSecurity(null);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(productionEndpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("production"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("production");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"admin1234".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        this.requestHeadersGet.put("Authorization", "Bearer " + this.productionApplication.getToken().getAccessToken());
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"admin1234".concat(":").concat("admin123#QA").getBytes())));
        this.requestHeadersGet.put("Authorization", "Bearer " + this.sandboxApplication.getToken().getAccessToken());
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"");
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testUpdateEndpointSecurityForProduction"})
    public void testUpdateEndpointSecurityForSandbox() throws Exception {
        String sandboxEndpointSecurity = "{\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"sandboxusername\",\n    \"password\":\"admin123#QA\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        apidto.setEndpointSecurity(null);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(sandboxEndpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("sandbox"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"sandboxusername".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        this.requestHeadersGet.put("Authorization", "Bearer " + this.productionApplication.getToken().getAccessToken());
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"");
        this.requestHeadersGet.put("Authorization", "Bearer " + this.sandboxApplication.getToken().getAccessToken());
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"sandboxusername".concat(":").concat("admin123#QA").getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testUpdateEndpointSecurityForSandbox"})
    public void testUpdateEndpointSecurityForSandboxAndProduction() throws Exception {
        String sandboxEndpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"production1234\",\n    \"password\":\"admin123#dev\"\n  },\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"sandbox1234\",\n    \"password\":\"admin123#prod\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        apidto.setEndpointSecurity(null);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(sandboxEndpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("sandbox"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"sandbox1234".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        Assert.assertNotNull(endpointSecurity.get("production"));
        Map productionMap = (Map)endpointSecurity.get("production");
        Assert.assertTrue((boolean)((Boolean)productionMap.get("enabled")));
        Assert.assertTrue((boolean)"production1234".equals(productionMap.get("username")));
        Assert.assertTrue((boolean)"".equals(productionMap.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)productionMap.get("type")));
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        this.requestHeadersGet.put("Authorization", "Bearer " + this.productionApplication.getToken().getAccessToken());
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"production1234".concat(":").concat("admin123#dev").getBytes())));
        this.requestHeadersGet.put("Authorization", "Bearer " + this.sandboxApplication.getToken().getAccessToken());
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"sandbox1234".concat(":").concat("admin123#prod").getBytes())));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.removeApplicationById(this.applicationID);
        this.restAPIPublisher.deleteAPIByID(this.apiID);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

