/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.lifecycle.LifeCycleAdminClient;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class CustomLifeCycleTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "APICustomLifecycleTestApi";
    private LifeCycleAdminClient lifeCycleAdminClient;
    private String customizedAPILifecyclePath = FrameworkPathUtil.getSystemResourceLocation() + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "customLifecycleTest" + File.separator + "APILifeCycle.xml";
    private String originalLifeCycleContent;
    private String apiEndPointUrl;
    private AuthenticatorClient loginClient;
    private String backendUrl;
    private String apiLifeCycleName = "APILifeCycle";
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public CustomLifeCycleTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.backendUrl = this.gatewayContextMgt.getContextUrls().getBackEndUrl();
        this.loginClient = new AuthenticatorClient(this.backendUrl);
        String session = this.loginClient.login(this.user.getUserName(), this.user.getPassword(), "localhost");
        this.lifeCycleAdminClient = new LifeCycleAdminClient(this.backendUrl, session);
        this.originalLifeCycleContent = this.lifeCycleAdminClient.getLifecycleConfiguration(this.apiLifeCycleName);
        String customizedAPILifecycleContent = FileManager.readFile((String)this.customizedAPILifecyclePath);
        this.lifeCycleAdminClient.editLifeCycle(this.apiLifeCycleName, customizedAPILifecycleContent);
        String gatewayUrl = "carbon.super".equals(this.gatewayContextWrk.getContextTenant().getDomain()) ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(API_NAME, "{version}/api", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setSandbox(this.apiEndPointUrl);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Check custom life cycle state.")
    public void testCustomLifeCycle() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        Assert.assertEquals((String)APILifeCycleState.PUBLISHED.getState(), (String)this.restAPIPublisher.getLifecycleStatus(this.apiId).getData(), (String)"lifecycle not changed to published");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PROMOTE.getAction());
        Assert.assertEquals((String)APILifeCycleState.PROMOTED.getState(), (String)this.restAPIPublisher.getLifecycleStatus(this.apiId).getData(), (String)"lifecycle not changed to custom");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.RE_PUBLISH.getAction());
        Assert.assertEquals((String)APILifeCycleState.PUBLISHED.getState(), (String)this.restAPIPublisher.getLifecycleStatus(this.apiId).getData(), (String)"lifecycle not changed to published");
    }

    @AfterClass
    public void cleanupArtifacts() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

