/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleHistoryDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.LifecycleStateDTO;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;

public class RegistryLifeCycleInclusionTest
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "RegistryLifeCycleInclusionAPI";
    private final String API_CONTEXT = "RegistryLifeCycleInclusionAPI";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String API_VERSION_2_0_0 = "2.0.0";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String apiID;
    private String copyApiID;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("RegistryLifeCycleInclusionAPI", "RegistryLifeCycleInclusionAPI", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
    }

    @Test(groups={"wso2.am"}, description="Test LC tab of an published api")
    public void testAPIInfoLifecycleTabForPublishedAPI() throws Exception {
        String[] expectedStates;
        APIDTO apidto = this.createAndPublishAPI(this.apiCreationRequestBean, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RegistryLifeCycleInclusionAPI", API_VERSION_1_0_0, "\"isApiExists\":true");
        this.apiID = apidto.getId();
        LifecycleStateDTO stateDTO = this.restAPIPublisher.getLifecycleStatusDTO(this.apiID);
        for (String state : expectedStates = new String[]{APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction(), APILifeCycleAction.BLOCK.getAction(), APILifeCycleAction.DEMOTE_TO_CREATE.getAction(), APILifeCycleAction.DEPRECATE.getAction()}) {
            AtomicBoolean found = new AtomicBoolean(false);
            stateDTO.getAvailableTransitions().forEach(transit -> {
                if (state.equalsIgnoreCase(transit.getEvent())) {
                    found.set(true);
                }
            });
            Assert.assertTrue((boolean)found.get());
        }
        LifecycleHistoryDTO historyDTO = this.restAPIPublisher.getLifecycleHistory(this.apiID);
        AtomicBoolean found = new AtomicBoolean(false);
        historyDTO.getList().forEach(item -> {
            if (APILifeCycleState.CREATED.getState().equalsIgnoreCase(item.getPreviousState()) && APILifeCycleState.PUBLISHED.getState().equalsIgnoreCase(item.getPostState())) {
                found.set(true);
            }
        });
        Assert.assertTrue((boolean)found.get());
    }

    @Test(groups={"wso2.am"}, description="Test checklist item visibility for new version of an api", dependsOnMethods={"testAPIInfoLifecycleTabForPublishedAPI"})
    public void testChecklistItemsVisibility() throws Exception {
        String[] expectedStates;
        APIDTO apidto = this.copyAPI(this.apiID, API_VERSION_2_0_0, this.restAPIPublisher);
        this.copyApiID = apidto.getId();
        LifecycleStateDTO stateDTO = this.restAPIPublisher.getLifecycleStatusDTO(this.copyApiID);
        Assert.assertEquals((Object)stateDTO.getState(), (Object)APILifeCycleState.CREATED.getState());
        for (String state : expectedStates = new String[]{APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction(), APILifeCycleAction.PUBLISH.getAction()}) {
            AtomicBoolean found = new AtomicBoolean(false);
            stateDTO.getAvailableTransitions().forEach(transit -> {
                if (state.equalsIgnoreCase(transit.getEvent())) {
                    found.set(true);
                }
            });
            Assert.assertTrue((boolean)found.get());
        }
    }

    @Test(groups={"wso2.am"}, description="Test LC state change visibility in the LC tab in publisher", dependsOnMethods={"testChecklistItemsVisibility"})
    public void testLCStateChangeVisibility() throws Exception {
        String[] expectedStates2;
        String[] expectedStates1;
        String[] expectedStates;
        this.restAPIPublisher.changeAPILifeCycleStatus(this.copyApiID, APILifeCycleAction.PUBLISH.getAction());
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RegistryLifeCycleInclusionAPI", API_VERSION_2_0_0, "\"isApiExists\":true");
        LifecycleStateDTO stateDTO = this.restAPIPublisher.getLifecycleStatusDTO(this.copyApiID);
        Assert.assertEquals((Object)stateDTO.getState(), (Object)APILifeCycleState.PUBLISHED.getState());
        for (String string : expectedStates = new String[]{APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction(), APILifeCycleAction.BLOCK.getAction(), APILifeCycleAction.DEMOTE_TO_CREATE.getAction(), APILifeCycleAction.DEPRECATE.getAction()}) {
            AtomicBoolean found = new AtomicBoolean(false);
            stateDTO.getAvailableTransitions().forEach(transit -> {
                if (string.equalsIgnoreCase(transit.getEvent())) {
                    found.set(true);
                }
            });
            Assert.assertTrue((boolean)found.get());
        }
        LifecycleHistoryDTO historyDTO = this.restAPIPublisher.getLifecycleHistory(this.apiID);
        AtomicBoolean found = new AtomicBoolean(false);
        historyDTO.getList().forEach(item -> {
            if (APILifeCycleState.CREATED.getState().equalsIgnoreCase(item.getPreviousState()) && APILifeCycleState.PUBLISHED.getState().equalsIgnoreCase(item.getPostState())) {
                found.set(true);
            }
        });
        Assert.assertTrue((boolean)found.get());
        this.restAPIPublisher.changeAPILifeCycleStatus(this.copyApiID, APILifeCycleAction.BLOCK.getAction());
        this.waitForAPIDeployment();
        stateDTO = this.restAPIPublisher.getLifecycleStatusDTO(this.copyApiID);
        Assert.assertEquals((Object)stateDTO.getState(), (Object)APILifeCycleState.BLOCKED.getState());
        for (String state : expectedStates1 = new String[]{APILifeCycleAction.RE_PUBLISH.getAction(), APILifeCycleAction.DEPRECATE.getAction()}) {
            AtomicBoolean found1 = new AtomicBoolean(false);
            stateDTO.getAvailableTransitions().forEach(transit -> {
                if (state.equalsIgnoreCase(transit.getEvent())) {
                    found1.set(true);
                }
            });
            Assert.assertTrue((boolean)found1.get());
        }
        historyDTO = this.restAPIPublisher.getLifecycleHistory(this.copyApiID);
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        historyDTO.getList().forEach(item -> {
            if (APILifeCycleState.PUBLISHED.getState().equalsIgnoreCase(item.getPreviousState()) && APILifeCycleState.BLOCKED.getState().equalsIgnoreCase(item.getPostState())) {
                found1.set(true);
            }
        });
        Assert.assertTrue((boolean)atomicBoolean.get());
        this.restAPIPublisher.changeAPILifeCycleStatus(this.copyApiID, APILifeCycleAction.DEPRECATE.getAction());
        this.waitForAPIDeployment();
        stateDTO = this.restAPIPublisher.getLifecycleStatusDTO(this.copyApiID);
        Assert.assertEquals((Object)stateDTO.getState(), (Object)APILifeCycleState.DEPRECATED.getState());
        for (String state : expectedStates2 = new String[]{APILifeCycleAction.RETIRE.getAction()}) {
            AtomicBoolean found2 = new AtomicBoolean(false);
            stateDTO.getAvailableTransitions().forEach(transit -> {
                if (state.equalsIgnoreCase(transit.getEvent())) {
                    found2.set(true);
                }
            });
            Assert.assertTrue((boolean)found2.get());
        }
        historyDTO = this.restAPIPublisher.getLifecycleHistory(this.copyApiID);
        AtomicBoolean found2 = new AtomicBoolean(false);
        historyDTO.getList().forEach(item -> {
            if (APILifeCycleState.BLOCKED.getState().equalsIgnoreCase(item.getPreviousState()) && APILifeCycleState.DEPRECATED.getState().equalsIgnoreCase(item.getPostState())) {
                found2.set(true);
            }
        });
        Assert.assertTrue((boolean)found2.get());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

