/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class UsersAndDocsInAPIOverviewTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "UsersAndDocsInAPIOverviewTest";
    private final String API_CONTEXT = "UsersAndDocsInAPIOverview";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String USER_KEY_USER2 = "userKey1";
    private final String APPLICATION_NAME = "UsersAndDocsInAPIOverviewTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private String apiID;
    private String app1ID;
    private String app2ID;
    private APIIdentifier apiIdentifier;
    private RestAPIStoreImpl apiStoreClientUser1;
    private RestAPIStoreImpl apiStoreClientUser2;
    private APICreationRequestBean apiCreationRequestBean;

    @Factory(dataProvider="userModeDataProvider")
    public UsersAndDocsInAPIOverviewTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("UsersAndDocsInAPIOverviewTest", "UsersAndDocsInAPIOverview", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiStoreClientUser1 = this.getRestAPIStoreForUser(this.user.getUserName(), this.user.getPassword(), this.user.getUserDomain());
        this.apiStoreClientUser2 = this.getRestAPIStoreForUser(this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getPassword(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserDomain());
        this.apiIdentifier = new APIIdentifier(this.providerName, "UsersAndDocsInAPIOverviewTest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="test the user count in API overview is correct")
    public void testNumberOfUsersInAPIOverview() throws Exception {
        String applicationDescription = "";
        String applicationCallBackUrl = "";
        ApplicationDTO app1 = this.apiStoreClientUser1.addApplication("UsersAndDocsInAPIOverviewTestCase", "50PerMin", applicationCallBackUrl, applicationDescription);
        ApplicationDTO app2 = this.apiStoreClientUser2.addApplication("UsersAndDocsInAPIOverviewTestCase", "50PerMin", applicationCallBackUrl, applicationDescription);
        this.app1ID = app1.getApplicationId();
        this.app2ID = app2.getApplicationId();
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "UsersAndDocsInAPIOverviewTest", "1.0.0");
        apiIdentifier.setTier("Gold");
        APIDTO apidto = this.createPublishAndSubscribeToAPI(apiIdentifier, this.apiCreationRequestBean, this.restAPIPublisher, this.apiStoreClientUser1, app1.getApplicationId(), "Gold");
        this.apiID = apidto.getId();
        SubscriptionListDTO subscriptionListDTO = this.restAPIPublisher.getSubscriptionByAPIID(apidto.getId());
        Assert.assertEquals((int)subscriptionListDTO.getCount(), (int)1);
        this.apiStoreClientUser2.subscribeToAPI(this.apiID, app2.getApplicationId(), "Gold");
        SubscriptionListDTO subscriptionListDTO1 = this.restAPIPublisher.getSubscriptionByAPIID(apidto.getId());
        Assert.assertEquals((int)subscriptionListDTO1.getCount(), (int)2);
        for (SubscriptionDTO dto : subscriptionListDTO1.getList()) {
            ApplicationInfoDTO infoDTO = dto.getApplicationInfo();
            if (infoDTO.getApplicationId().equalsIgnoreCase(app1.getApplicationId())) {
                Assert.assertEquals((String)infoDTO.getSubscriber(), (String)this.user.getUserName());
            }
            if (!infoDTO.getApplicationId().equalsIgnoreCase(app2.getApplicationId())) continue;
            Assert.assertEquals((String)infoDTO.getSubscriber(), (String)this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName());
        }
    }

    @Test(groups={"wso2.am"}, description="test user information in API overview Docs tab is correct", dependsOnMethods={"testNumberOfUsersInAPIOverview"})
    public void testDocInformationInDocsTabInAPIOverview() throws Exception {
        DocumentDTO documentDTO1 = new DocumentDTO();
        documentDTO1.setName("Doc1");
        documentDTO1.setType(DocumentDTO.TypeEnum.HOWTO);
        documentDTO1.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        documentDTO1.setSummary("test doc 1");
        documentDTO1.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        DocumentDTO documentDTO2 = new DocumentDTO();
        documentDTO2.setName("Doc2");
        documentDTO2.setType(DocumentDTO.TypeEnum.HOWTO);
        documentDTO2.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        documentDTO2.setSummary("test doc 2");
        documentDTO2.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        this.restAPIPublisher.addDocument(this.apiID, documentDTO1);
        this.restAPIPublisher.addDocument(this.apiID, documentDTO2);
        DocumentListDTO documentListDTO = this.restAPIPublisher.getDocuments(this.apiID);
        Assert.assertEquals((int)documentListDTO.getCount(), (int)2);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        if (this.apiStoreClientUser1 != null) {
            this.apiStoreClientUser1.removeApplicationById(this.app1ID);
        }
        if (this.apiStoreClientUser2 != null) {
            this.apiStoreClientUser2.removeApplicationById(this.app2ID);
        }
        this.restAPIPublisher.deleteAPIByID(this.apiID);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

