/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class CAPIMGT12CallBackURLOverwriteTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(CAPIMGT12CallBackURLOverwriteTestCase.class);
    private static final String TEST_USER_1 = "TestUser1001";
    private static final String TEST_USER_2 = "TestUser2002";
    private static final String TEST_USER_1_PASSWORD = "12345";
    private static final String TEST_USER_2_PASSWORD = "12345";
    private static final String TEST_APPLICATION = "TestApplication";
    private static final String USER_1_TEST_APP_INITIAL_CBU = "www.user1-app-initial-callback-url.com";
    private static final String USER_2_TEST_APP_INITIAL_CBU = "www.user2-app-initial-callback-url.com";
    private static final String USER_2_TEST_APP_UPDATED_CBU = "www.user2-app-updated-callback-url.com";
    private ArrayList<String> grantTypes = new ArrayList();
    private RestAPIStoreImpl user1ApiStore;
    private RestAPIStoreImpl user2ApiStore;
    private String user1ApplicationId;
    private String user2ApplicationId;

    @BeforeClass(alwaysRun=true)
    public void init() throws APIManagerIntegrationTestException {
        super.init();
        try {
            this.userManagementClient.addUser(TEST_USER_1, "12345", new String[]{"admin"}, "manager");
            this.userManagementClient.addUser(TEST_USER_2, "12345", new String[]{"admin"}, "manager");
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)"Error while creating the test users");
            Assert.fail((String)e.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)"Error while creating the test users");
            Assert.fail((String)e.getMessage());
        }
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.user1ApiStore = new RestAPIStoreImpl(TEST_USER_1, "12345", "carbon.super", this.storeURLHttps);
        this.user2ApiStore = new RestAPIStoreImpl(TEST_USER_2, "12345", "carbon.super", this.storeURLHttps);
        this.grantTypes.add("client_credentials");
        this.grantTypes.add("password");
    }

    @Test(groups={"wso2.am"}, description="Application call back url update and overwriting test case")
    public void callBackUrlUpdateTestCase() throws Exception {
        this.addAppsAndGenerateKeys();
        this.grantTypes.add("urn:ietf:params:oauth:grant-type:saml2-bearer");
        this.grantTypes.add("iwa:ntlm");
        ApplicationKeyDTO applicationKeyDTO = new ApplicationKeyDTO();
        applicationKeyDTO.setKeyType(ApplicationKeyDTO.KeyTypeEnum.PRODUCTION);
        applicationKeyDTO.setCallbackUrl(USER_2_TEST_APP_UPDATED_CBU);
        applicationKeyDTO.setSupportedGrantTypes(this.grantTypes);
        ApiResponse updateResponse = this.user2ApiStore.updateKeys(this.user2ApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.toString(), applicationKeyDTO);
        Assert.assertEquals((int)updateResponse.getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when adding an application");
        ApiResponse getKeysForUser1Response = this.user1ApiStore.getApplicationKeysByKeyType(this.user1ApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        Assert.assertEquals((int)getKeysForUser1Response.getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)("Error when re-generating consumer secret for application: " + this.user1ApplicationId));
        Assert.assertNotNull((Object)((ApplicationKeyDTO)getKeysForUser1Response.getData()).getConsumerKey(), (String)"Error in generating keys for application: TestApplication");
        ApiResponse getKeysForUser2Response = this.user2ApiStore.getApplicationKeysByKeyType(this.user2ApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        Assert.assertEquals((int)getKeysForUser2Response.getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)("Error when re-generating consumer secret for application: " + this.user2ApplicationId));
        Assert.assertNotNull((Object)((ApplicationKeyDTO)getKeysForUser2Response.getData()).getConsumerKey(), (String)"Error in generating keys for application: TestApplication");
        String finalCallbackUrlUser1App = ((ApplicationKeyDTO)getKeysForUser1Response.getData()).getCallbackUrl();
        String finalCallbackUrlUser2App = ((ApplicationKeyDTO)getKeysForUser2Response.getData()).getCallbackUrl();
        Assert.assertEquals((String)finalCallbackUrlUser1App, (String)USER_1_TEST_APP_INITIAL_CBU, (String)"Call back URL of the first user's application has been overwritten due to the update of the call back URL of second user's application.");
        Assert.assertNotEquals((Object)finalCallbackUrlUser1App, (Object)finalCallbackUrlUser2App, (String)"Call back URL of the first user's application has been overwritten due to the update of the call back URL of second user's application.");
    }

    public void addAppsAndGenerateKeys() throws Exception {
        HttpResponse applicationResponse = this.user1ApiStore.createApplication(TEST_APPLICATION, "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.user1ApplicationId = applicationResponse.getData();
        ApplicationKeyDTO applicationKeyDTO = this.user1ApiStore.generateKeys(this.user1ApplicationId, "3600", USER_1_TEST_APP_INITIAL_CBU, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        applicationResponse = this.user2ApiStore.createApplication(TEST_APPLICATION, "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.user2ApplicationId = applicationResponse.getData();
        applicationKeyDTO = this.user2ApiStore.generateKeys(this.user2ApplicationId, "3600", USER_2_TEST_APP_INITIAL_CBU, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.user1ApiStore.deleteApplication(this.user1ApplicationId);
        this.user2ApiStore.deleteApplication(this.user2ApplicationId);
        this.userManagementClient.deleteUser(TEST_USER_1);
        this.userManagementClient.deleteUser(TEST_USER_2);
    }
}

