/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class ESBJAVA5121CheckAuthHeaderOrderTestCase
extends APIMIntegrationBaseTest {
    public WireMonitorServer wireServer;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.wireServer = new WireMonitorServer(8991);
        AuthenticatorClient login = new AuthenticatorClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl());
        String session = login.login("admin", "admin", "localhost");
        String file = "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "auth_headers.xml";
        OMElement synapseConfig = APIMTestCaseUtils.loadResource((String)file);
        APIMTestCaseUtils.updateSynapseConfiguration((OMElement)synapseConfig, (String)this.gatewayContextMgt.getContextUrls().getBackEndUrl(), (String)session);
        Thread.sleep(5000L);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
    @Test(groups={"wso2.am"}, description="Test for checking the order of the auth headers before sending the request to the backend")
    public void testAuthHeaderOrder() throws Exception {
        this.wireServer.start();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpGet = new HttpGet(this.gatewayUrlsWrk.getWebAppURLNhttp() + "check/");
        httpGet.addHeader("WWW-Authenticate", "NTLM");
        httpGet.addHeader("WWW-Authenticate", "Basic realm=\"BasicSecurityFilterProvider\"");
        httpGet.addHeader("WWW-Authenticate", "ANTLM3");
        httpClient.execute((HttpUriRequest)httpGet);
        String response = this.wireServer.getCapturedMessage();
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.contains("WWW-Authenticate: NTLM\r\nWWW-Authenticate: Basic realm=\"BasicSecurityFilterProvider\"\r\nWWW-Authenticate: ANTLM3"));
    }

    @AfterClass(alwaysRun=true)
    public void stop() throws Exception {
        this.cleanUp();
    }
}

