/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class JWTRevocationTestCase
extends APIManagerLifecycleBaseTest {
    private String consumerKey;
    private String consumerSecret;
    private String apiId;
    private String appId;
    private static final String APP_NAME = "JWTTokenRevocationTest-Application";
    private static final String API_NAME = "JWTTokenTestAPI";
    private static final String API_CONTEXT = "jwtTokenTestAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String API_END_POINT_RESOURCE = "/customers/123";
    private static final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private Map<String, String> apiInvocationRequestHeaders;
    String apiInvocationUrl;
    String accessToken;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        HttpResponse applicationResponse = this.restAPIStore.createApplication(APP_NAME, "This is a test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.appId = applicationResponse.getData();
        String endpointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(endpointUrl));
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.appId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.appId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        this.apiInvocationUrl = this.getAPIInvocationURLHttp("jwtTokenTestAPI/1.0.0/customers/123");
        this.apiInvocationRequestHeaders = new HashMap<String, String>();
        this.apiInvocationRequestHeaders.put("accept", "text/xml");
        this.apiInvocationRequestHeaders.put("Authorization", "Bearer " + this.accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="testing jwt token revocation")
    public void testJWTTokenRevocation() throws Exception {
        HttpResponse invocationResponseAfterRevoked;
        HttpResponse invocationResponse = HttpRequestUtil.doGet((String)this.apiInvocationUrl, this.apiInvocationRequestHeaders);
        org.testng.Assert.assertEquals((int)invocationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before Retire");
        org.testng.Assert.assertTrue((boolean)invocationResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke  API  before Retire Response Data:" + invocationResponse.getData()));
        HashMap<String, String> revokeRequestHeaders = new HashMap<String, String>();
        String basicAuthHeader = this.consumerKey + ":" + this.consumerSecret;
        byte[] encodedBytes = Base64.encodeBase64((byte[])basicAuthHeader.getBytes(StandardCharsets.UTF_8));
        revokeRequestHeaders.put("Authorization", "Basic " + new String(encodedBytes, StandardCharsets.UTF_8));
        String input = "token=" + this.accessToken;
        URL revokeEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "revoke");
        try {
            HttpResponse revokeResponse = HTTPSClientUtils.doPost((URL)revokeEndpointURL, (String)input, revokeRequestHeaders);
            org.testng.Assert.assertEquals((int)revokeResponse.getResponseCode(), (int)200);
            org.testng.Assert.assertEquals((String)((String)revokeResponse.getHeaders().get("RevokedAccessToken")), (String)this.accessToken, (String)"Access token is not revoked correctly");
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw any exceptions" + e));
        }
        boolean isTokenValid = true;
        int counter = 1;
        do {
            Thread.sleep(1000L);
            invocationResponseAfterRevoked = HttpRequestUtil.doGet((String)this.apiInvocationUrl, this.apiInvocationRequestHeaders);
            int invocationResponseCodeAfterRevoked = invocationResponseAfterRevoked.getResponseCode();
            if (invocationResponseCodeAfterRevoked == HTTP_RESPONSE_CODE_UNAUTHORIZED) {
                isTokenValid = false;
                continue;
            }
            if (invocationResponseCodeAfterRevoked == HTTP_RESPONSE_CODE_OK) {
                isTokenValid = true;
                continue;
            }
            throw new APIManagerIntegrationTestException("Unexpected response received when invoking the API. Response received :" + invocationResponseAfterRevoked.getData() + ":" + invocationResponseAfterRevoked.getResponseMessage());
        } while (isTokenValid && ++counter < 20);
        org.testng.Assert.assertFalse((boolean)isTokenValid, (String)("Access token revocation failed. API invocation response code is expected to be : " + HTTP_RESPONSE_CODE_UNAUTHORIZED + ", but got " + invocationResponseAfterRevoked.getResponseCode()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.appId);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

