/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class MicroGWJWTRevocationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(MicroGWJWTRevocationTestCase.class);
    private String consumerKey;
    private String consumerSecret;
    private String userName;
    private String password;
    private String jti;
    private String jtiExtracted;
    private final String KEYSTORE_FILE_PATH_CLIENT = TestConfigurationProvider.getResourceLocation() + File.separator + "keystores" + File.separator + "products" + File.separator + "wso2carbon.jks";
    private final String TRUSTSTORE_FILE_PATH_CLIENT = TestConfigurationProvider.getResourceLocation() + File.separator + "keystores" + File.separator + "products" + File.separator + "client-truststore.jks";
    private TopicConnection topicConnection;
    private TopicSession topicConsumerSession;
    private MessageConsumer consumer;
    private String apiId;
    private String applicationId;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        log.info((Object)"MicroGWJWTRevocationTestCase  Initiated");
        super.init();
        this.userName = this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName();
        this.password = this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword();
        System.setProperty("javax.net.ssl.keyStoreType", "JKS");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        System.setProperty("javax.net.ssl.keyStore", this.KEYSTORE_FILE_PATH_CLIENT);
        System.setProperty("javax.net.ssl.keyStorePassword", "wso2carbon");
        System.setProperty("javax.net.ssl.trustStore", this.TRUSTSTORE_FILE_PATH_CLIENT);
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        APIRequest apiRequest = new APIRequest("test", "test", new URL("http://localhost:6789"));
        apiRequest.setVisibility("public");
        HttpResponse response = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = response.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        HttpResponse applicationResponse = this.restAPIStore.createApplication("JWTTokenTestAPI-Application", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.restAPIStore.createSubscription(this.apiId, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        try {
            this.createJMSConnection();
        }
        catch (NamingException e) {
            log.error((Object)"Error while Creating JMS Connection - Naming Exception:", (Throwable)e);
        }
        catch (JMSException e) {
            log.error((Object)"Error while Creating JMS Connection - JMS Exception:", (Throwable)e);
        }
        log.info((Object)"MicroGWJWTRevocationTestCase  Environment Setup Completed");
    }

    private void createJMSConnection() throws JMSException, NamingException {
        String QPID_ICF = "org.wso2.andes.jndi.PropertiesFileInitialContextFactory";
        String CF_NAME_PREFIX = "connectionfactory.";
        String CF_NAME = "qpidConnectionfactory";
        String topicName = "tokenRevocation";
        String JMSConnectionURL = "amqp://admin:admin@clientid/carbon?brokerlist='tcp://localhost:6172'";
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", QPID_ICF);
        properties.put(CF_NAME_PREFIX + CF_NAME, JMSConnectionURL);
        InitialContext ctx = new InitialContext(properties);
        TopicConnectionFactory connFactory = (TopicConnectionFactory)ctx.lookup(CF_NAME);
        this.topicConnection = connFactory.createTopicConnection();
        this.topicConsumerSession = this.topicConnection.createTopicSession(false, 1);
        Topic topic = this.topicConsumerSession.createTopic(topicName);
        this.consumer = this.topicConsumerSession.createSubscriber(topic);
        this.topicConnection.start();
    }

    @Test(groups={"wso2.am"}, description="JWT revocation test")
    public void revokeRequestTestCase() throws Exception {
        log.info((Object)"revokeRequestTestCase  Initiated");
        String requestBody = "grant_type=password&username=" + this.userName + "&password=" + this.password;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        HashMap<String, String> authenticationRequestHeaders = new HashMap<String, String>();
        String basicAuthHeader = this.consumerKey + ":" + this.consumerSecret;
        byte[] encodedBytes = Base64.encodeBase64((byte[])basicAuthHeader.getBytes(StandardCharsets.UTF_8));
        authenticationRequestHeaders.put("Authorization", "Basic " + new String(encodedBytes, StandardCharsets.UTF_8));
        JSONObject accessTokenGenerationResponse = new JSONObject(HTTPSClientUtils.doPost((URL)tokenEndpointURL, (String)requestBody, authenticationRequestHeaders).getData());
        String jwtAccessToken = accessTokenGenerationResponse.getString("access_token");
        int firstDotSeparatorIndex = jwtAccessToken.indexOf(46);
        int secondSeparatorIndex = jwtAccessToken.indexOf(46, firstDotSeparatorIndex + 1);
        String JWTToken = jwtAccessToken.substring(firstDotSeparatorIndex + 1, secondSeparatorIndex);
        byte[] decodedJwt = Base64.decodeBase64((byte[])JWTToken.getBytes());
        JSONObject jsonObject = new JSONObject(new String(decodedJwt));
        this.jtiExtracted = jsonObject.get("jti").toString();
        String input = "token=" + this.jtiExtracted;
        URL revokeEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "revoke");
        try {
            HttpResponse httpResponse = HTTPSClientUtils.doPost((URL)revokeEndpointURL, (String)input, authenticationRequestHeaders);
            org.testng.Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200);
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw any exceptions" + e));
        }
        log.info((Object)"revokeRequestTestCase  Finished");
    }

    @Test(groups={"wso2.am"}, description="JWT revocation test", dependsOnMethods={"revokeRequestTestCase"})
    public void checkETCDForRevokedJTITestCase() throws Exception {
        log.info((Object)"checkETCDForRevokedJTITTestCase  Initiated");
        String etcdEndpointURLs = "https://localhost:9943/etcdmock/v2/keys/jti/2f3c1e3a-fe4c-4cd4-b049-156e3c63fc5d";
        URL etcdEndpointURL = new URL("https://localhost:9943/etcdmock/v2/keys/jti/2f3c1e3a-fe4c-4cd4-b049-156e3c63fc5d");
        HashMap<String, String> authenticationRequestHeaders = new HashMap<String, String>();
        authenticationRequestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        String retrievedETCDJTIKey = "";
        String input = "";
        try {
            HTTPSClientUtils.doPost((URL)etcdEndpointURL, (String)input, authenticationRequestHeaders);
            JSONObject etcdResponse = new JSONObject(HTTPSClientUtils.doGet((String)etcdEndpointURLs, authenticationRequestHeaders).getData());
            Iterator keys = etcdResponse.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.equalsIgnoreCase("node")) continue;
                JSONObject childObject = (JSONObject)etcdResponse.get("node");
                Iterator childKeys = childObject.keys();
                while (childKeys.hasNext()) {
                    String childKey = (String)childKeys.next();
                    if (!childKey.equalsIgnoreCase("key")) continue;
                    retrievedETCDJTIKey = childObject.getString(childKey).substring(5);
                }
            }
        }
        catch (JSONException e) {
            Assert.fail((String)("Should not throw any exceptions" + (Object)((Object)e)));
        }
        this.jti = "2f3c1e3a-fe4c-4cd4-b049-156e3c63fc5d";
        org.testng.Assert.assertEquals((String)retrievedETCDJTIKey, (String)this.jti);
        log.info((Object)"checkETCDForRevokedJTITTestCase  Finished");
    }

    @Test(groups={"wso2.am"}, description="JWT revocation test", dependsOnMethods={"revokeRequestTestCase"})
    public void checkJMSTopicForRevokedJTITestCase() throws Exception {
        log.info((Object)"checkJMSTopicForRevokedJTITTestCase  Initiated");
        Message message = this.consumer.receive();
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            org.testng.Assert.assertEquals((String)mapMessage.getString("revokedToken"), (String)this.jtiExtracted);
        }
        this.topicConsumerSession.close();
        this.topicConnection.close();
        log.info((Object)"checkJMSTopicForRevokedJTITTestCase  Finished");
    }

    @AfterClass(alwaysRun=true)
    void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

