/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt.idp;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.am.integration.tests.jwt.idp.JWTGeneratorUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class ExternalIDPJWTTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ExternalIDPJWTTestCase.class);
    private String apiName = "ExternalJWTTest";
    private String apiContext = "externaljwtTest";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String jwtApplicationName = "JWTAppFOrJWTTest";
    private static final String ISSUER_1 = "https://test.apim.integration";
    private static final String ISSUER_2 = "https://test2.apim.integration";
    private String endpointURL;
    private String jwtApplicationId;
    private String apiId;
    URL tokenEndpointURL;
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        this.providerName = this.user.getUserName();
        this.endpointURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationDTO = this.restAPIStore.createApplication(this.jwtApplicationName, "JWT Application", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.jwtApplicationId = applicationDTO.getData();
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.endpointURL));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setVisibility("public");
        apiRequest.setProvider(this.providerName);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.restAPIStore.subscribeToAPI(this.apiId, this.jwtApplicationId, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        this.restAPIStore.generateKeys(this.jwtApplicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT")
    public void testInvokeExternalIDPGeneratedJWT() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", applicationKeyDTO.getConsumerKey());
        attributes.put("http://idp.org/claims/givenname", "first");
        attributes.put("http://idp.org/claims/firstname", "last");
        attributes.put("http://idp.org/claims/email", "first@gmail.com");
        attributes.put("http://idp.org/claims/mobileno", "424479772294778");
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", ISSUER_1, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        log.info((Object)("External IDP JWT Generated: " + generatedJWT));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        if (this.userMode == TestUserMode.SUPER_TENANT_ADMIN || this.userMode == TestUserMode.SUPER_TENANT_USER || this.userMode == TestUserMode.SUPER_TENANT_EMAIL_USER) {
            String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
            String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
            boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
            AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
        }
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        Object givenName = jsonObject.get("http://wso2.org/claims/givenname");
        Assert.assertNotNull((Object)givenName);
        Assert.assertEquals((Object)givenName, (Object)"first");
        Object firstName = jsonObject.get("http://wso2.org/claims/firstname");
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)firstName, (Object)"last");
        Object email = jsonObject.get("http://wso2.org/claims/email");
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)email, (Object)"first@gmail.com");
        try {
            Object mobileno = jsonObject.get("http://idp.org/claims/mobileno");
            Assert.assertNull((Object)mobileno);
        }
        catch (JSONException e) {
            Assert.assertTrue((boolean)true, (String)"Claim not in jwt");
        }
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT Consumer key is invalid")
    public void testInvokeExternalIDPGeneratedJWTNegative1() throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", UUID.randomUUID().toString());
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", ISSUER_1, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation");
        String payload = IOUtils.toString((InputStream)response.getEntity().getContent());
        Assert.assertTrue((boolean)payload.contains("900908"));
        Assert.assertTrue((boolean)payload.contains("User is NOT authorized to access the Resource. API Subscription validation failed."));
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT Certificate is unknown")
    public void testInvokeExternalIDPGeneratedJWTNegative2() throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore2.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", UUID.randomUUID().toString());
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", ISSUER_2, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (String)"Response code mismatched when api invocation");
        String payload = IOUtils.toString((InputStream)response.getEntity().getContent());
        Assert.assertTrue((boolean)payload.contains("900900"));
        Assert.assertTrue((boolean)payload.contains("Unclassified Authentication Failure"));
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT")
    public void testInvokeExternalIDPGeneratedJWT1() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "idp1.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", applicationKeyDTO.getConsumerKey());
        attributes.put("http://idp2.org/claims/givenname", "first");
        attributes.put("http://idp2.org/claims/firstname", "last");
        attributes.put("http://idp2.org/claims/email", "first@gmail.com");
        attributes.put("http://idp2.org/claims/mobileno", "424479772294778");
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idp2certificate", "idp1", "wso2carbon", "wso2carbon", "userexternal", ISSUER_2, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        log.info((Object)("External IDP JWT Generated: " + generatedJWT));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        if (this.userMode == TestUserMode.SUPER_TENANT_ADMIN || this.userMode == TestUserMode.SUPER_TENANT_USER || this.userMode == TestUserMode.SUPER_TENANT_EMAIL_USER) {
            String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
            String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
            boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
            AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
        }
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        Object givenName = jsonObject.get("http://wso2.org/claims/givenname");
        Assert.assertNotNull((Object)givenName);
        Assert.assertEquals((Object)givenName, (Object)"first");
        Object firstName = jsonObject.get("http://wso2.org/claims/firstname");
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)firstName, (Object)"last");
        Object email = jsonObject.get("http://wso2.org/claims/email");
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)email, (Object)"first@gmail.com");
        try {
            Object mobileno = jsonObject.get("http://idp.org/claims/mobileno");
            Assert.assertNull((Object)mobileno);
        }
        catch (JSONException e) {
            Assert.assertTrue((boolean)true, (String)"Claim not in jwt");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public ExternalIDPJWTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

