/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt.idp;

import java.io.File;
import java.nio.file.Paths;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class ExternalIDPJWTTestSuite
extends APIManagerLifecycleBaseTest {
    private ServerConfigurationManager serverConfigurationManager;

    @BeforeTest(alwaysRun=true)
    public void loadConfiguration() throws Exception {
        this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        File targetFile = Paths.get(FrameworkPathUtil.getCarbonHome(), "repository", "resources", "security", "client-truststore.jks").toFile();
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "idpjwt" + File.separator + "deployment.toml"));
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "idpjwt" + File.separator + "client-truststore.jks"), targetFile, true);
        this.serverConfigurationManager.restartGracefully();
    }

    @AfterTest(alwaysRun=true)
    public void restoreConfiguration() throws Exception {
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

