/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.oas;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.tests.oas.OASBaseUtils;

public class OAS2Utils {
    public static void validateOperationCount(APIDTO apidto, String swagger) throws Exception {
        SwaggerParser swaggerParser = new SwaggerParser();
        Swagger swaggerObj = swaggerParser.parse(swagger);
        int count = 0;
        for (Map.Entry entry : swaggerObj.getPaths().entrySet()) {
            Path path = (Path)entry.getValue();
            count += path.getOperations().size();
        }
        Assert.assertEquals((long)apidto.getOperations().size(), (long)count);
    }

    public static void validateSwaggerDataInPublisher(APIDTO apidto, String swagger) throws Exception {
        SwaggerParser swaggerParser = new SwaggerParser();
        Swagger swaggerObj = swaggerParser.parse(swagger);
        Map extensions = swaggerObj.getVendorExtensions();
        OASBaseUtils.validateSwaggerExtensionDataInPublisher(extensions, apidto);
    }

    public static void validateSwaggerDataInStore(String swagger) {
        SwaggerParser swaggerParser = new SwaggerParser();
        Swagger swaggerObj = swaggerParser.parse(swagger);
        Map extensions = swaggerObj.getVendorExtensions();
        if (extensions != null) {
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-auth-header"));
            Assert.assertFalse((boolean)extensions.containsKey("x-throttling-tier"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-cors"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-production-endpoints"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-sandbox-endpoints"));
            Assert.assertFalse((boolean)extensions.containsKey("x-wso2-transports"));
        }
        Map paths = swaggerObj.getPaths();
        Assert.assertNotNull((Object)paths);
        for (String pathKey : paths.keySet()) {
            Path path = (Path)paths.get(pathKey);
            Map operationMap = path.getOperationMap();
            for (Map.Entry entry : operationMap.entrySet()) {
                Operation operation = (Operation)entry.getValue();
                Map opsExMap = operation.getVendorExtensions();
                if (operationMap == null) continue;
                Assert.assertFalse((boolean)opsExMap.containsKey("x-mediation-script"));
            }
        }
    }

    public static void validateResourcesOfOASDefinition(APIDTO apidto, String swagger) {
        SwaggerParser swaggerParser = new SwaggerParser();
        Swagger swaggerObj = swaggerParser.parse(swagger);
        Assert.assertNotNull((Object)swaggerObj);
        for (APIOperationsDTO operation : apidto.getOperations()) {
            Map paths = swaggerObj.getPaths();
            Assert.assertNotNull((Object)paths);
            Path path = (Path)paths.get(operation.getTarget());
            Assert.assertNotNull((Object)path);
            Operation oasOperation = (Operation)path.getOperationMap().get(HttpMethod.valueOf((String)operation.getVerb()));
            Assert.assertNotNull((Object)oasOperation);
            for (String scope : operation.getScopes()) {
                boolean found = false;
                List securities = oasOperation.getSecurity();
                Assert.assertNotNull((Object)securities);
                for (Map aSec : securities) {
                    List defaultScopes = (List)aSec.get("default");
                    if (defaultScopes == null) continue;
                    Assert.assertTrue((boolean)((List)aSec.get("default")).contains(scope));
                    found = true;
                    break;
                }
                if (found) continue;
                Assert.fail((String)"Security not found");
            }
            Map ex = oasOperation.getVendorExtensions();
            Assert.assertNotNull((Object)ex);
            Assert.assertEquals((Object)operation.getAuthType(), ex.get("x-auth-type"));
            Assert.assertEquals((Object)operation.getThrottlingPolicy(), ex.get("x-throttling-tier"));
        }
    }

    public static void validateUpdatedDefinition(String original, String updated) {
        SwaggerParser swaggerParser = new SwaggerParser();
        Swagger originalObj = swaggerParser.parse(original);
        Swagger updatedObj = swaggerParser.parse(updated);
        Assert.assertEquals((long)originalObj.getPaths().size(), (long)updatedObj.getPaths().size());
        for (Map.Entry entry : originalObj.getPaths().entrySet()) {
            Path originalPath = (Path)entry.getValue();
            Path updatedPath = updatedObj.getPath((String)entry.getKey());
            Map originalOperationMap = originalPath.getOperationMap();
            Map updatedOperationMap = updatedPath.getOperationMap();
            Assert.assertEquals((long)originalOperationMap.size(), (long)updatedOperationMap.size());
            for (Map.Entry opEntry : originalOperationMap.entrySet()) {
                Operation originalOperation = (Operation)opEntry.getValue();
                Operation updatedOperation = (Operation)updatedOperationMap.get(opEntry.getKey());
                Assert.assertEquals((Object)originalOperation, (Object)updatedOperation);
            }
        }
    }

    public static void validateUpdatedDefinition(String original, APIDTO apidto) {
        SwaggerParser swaggerParser = new SwaggerParser();
        Swagger originalObj = swaggerParser.parse(original);
        Map<String, Map<String, APIOperationsDTO>> updatedPaths = OASBaseUtils.getMapFromDTO(apidto);
        Assert.assertEquals((long)originalObj.getPaths().size(), (long)updatedPaths.size());
        for (Map.Entry entry : originalObj.getPaths().entrySet()) {
            Path originalPath = (Path)entry.getValue();
            Map<String, APIOperationsDTO> updatedOps = updatedPaths.get(entry.getKey());
            Map originalOperationMap = originalPath.getOperationMap();
            Assert.assertEquals((long)originalOperationMap.size(), (long)updatedOps.size());
            for (Map.Entry opEntry : originalOperationMap.entrySet()) {
                Operation originalOperation = (Operation)opEntry.getValue();
                APIOperationsDTO updatedOperation = updatedOps.get(((HttpMethod)opEntry.getKey()).name());
                Assert.assertNotNull((Object)updatedOperation);
                if (updatedOperation.getScopes() != null && !updatedOperation.getScopes().isEmpty()) {
                    Assert.assertEquals(((List)((Map)originalOperation.getSecurity().get(0)).get("default")).get(0), updatedOperation.getScopes().get(0));
                    continue;
                }
                Assert.assertTrue((boolean)((List)((Map)originalOperation.getSecurity().get(0)).get("default")).isEmpty());
            }
        }
    }
}

