/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.oas;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.OpenAPIDefinitionValidationResponseDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.tests.oas.OAS2Utils;
import org.wso2.am.integration.tests.oas.OAS3Utils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class OASTestCase
extends APIMIntegrationBaseTest {
    private String apiId;
    private String apiImportId;
    private String resourcePath;
    private String oasVersion;
    private static final String OAS_V2 = "v2";
    private static final String OAS_V3 = "v3";

    @Factory(dataProvider="userModeDataProvider")
    public OASTestCase(TestUserMode userMode, String oasVersion) {
        this.userMode = userMode;
        this.oasVersion = oasVersion;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.resourcePath = OAS_V2.equalsIgnoreCase(this.oasVersion) ? "oas" + File.separator + OAS_V2 + File.separator : "oas" + File.separator + OAS_V3 + File.separator;
    }

    @Test(groups={"wso2.am"}, description="API creation")
    public void testNewAPI() throws Exception {
        String apiData = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "apiData.json"), (String)"UTF-8");
        ObjectMapper objectMapper = new ObjectMapper();
        APIDTO apidto = (APIDTO)objectMapper.readValue(apiData, APIDTO.class);
        apidto.setProvider(this.user.getUserName());
        APIDTO responseApiDto = this.restAPIPublisher.addAPI(apidto, this.oasVersion);
        this.apiId = responseApiDto.getId();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.testUpdatedAPIDefinitionInPublisher(apidto, this.oasVersion);
        this.testUpdatedAPIDefinitionInStore(apidto, this.oasVersion);
    }

    @Test(groups={"wso2.am"}, description="API update", dependsOnMethods={"testNewAPI"})
    public void testAPIUpdate() throws Exception {
        String updatedAPIData = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "apiUpdateData.json"), (String)"UTF-8");
        ObjectMapper objectMapper = new ObjectMapper();
        APIDTO apidto = (APIDTO)objectMapper.readValue(updatedAPIData, APIDTO.class);
        apidto.setProvider(this.user.getUserName());
        APIDTO updatedApidto = this.restAPIPublisher.updateAPI(apidto, this.apiId);
        this.testUpdatedAPIDefinitionInPublisher(apidto, this.oasVersion);
        this.testUpdatedAPIDefinitionInStore(apidto, this.oasVersion);
    }

    @Test(groups={"wso2.am"}, description="API definition update", dependsOnMethods={"testAPIUpdate"})
    public void testAPIDefinitionUpdate() throws Exception {
        String originalStoreDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "oas.json"), (String)"UTF-8");
        String originalPublisherDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "oas_publisher.json"), (String)"UTF-8");
        String responseDefinition = this.restAPIPublisher.updateSwagger(this.apiId, originalPublisherDefinition);
        APIDTO apidto = this.restAPIPublisher.getAPIByID(this.apiId, this.user.getUserDomain());
        Assert.assertNotNull((Object)apidto);
        String storeDefinition = this.restAPIStore.getSwaggerByID(this.apiId, this.user.getUserDomain());
        String publisherDefinition = this.restAPIPublisher.getSwaggerByID(this.apiId);
        this.validateDefinition(publisherDefinition);
        this.validateDefinition(responseDefinition);
        this.validateDefinition(storeDefinition);
        if (OAS_V2.equalsIgnoreCase(this.oasVersion)) {
            OAS2Utils.validateSwaggerDataInPublisher(apidto, responseDefinition);
            OAS2Utils.validateSwaggerDataInPublisher(apidto, publisherDefinition);
            OAS2Utils.validateSwaggerDataInStore(storeDefinition);
            OAS2Utils.validateUpdatedDefinition(originalPublisherDefinition, publisherDefinition);
            OAS2Utils.validateUpdatedDefinition(originalPublisherDefinition, responseDefinition);
            OAS2Utils.validateUpdatedDefinition(originalStoreDefinition, storeDefinition);
            OAS2Utils.validateUpdatedDefinition(originalPublisherDefinition, apidto);
        } else {
            OAS3Utils.validateSwaggerDataInPublisher(apidto, responseDefinition);
            OAS3Utils.validateSwaggerDataInPublisher(apidto, publisherDefinition);
            OAS3Utils.validateSwaggerDataInStore(storeDefinition);
            OAS3Utils.validateUpdatedDefinition(originalPublisherDefinition, publisherDefinition);
            OAS3Utils.validateUpdatedDefinition(originalPublisherDefinition, responseDefinition);
            OAS3Utils.validateUpdatedDefinition(originalStoreDefinition, storeDefinition);
            OAS3Utils.validateUpdatedDefinition(originalPublisherDefinition, apidto);
        }
    }

    @Test(groups={"wso2.am"}, description="API definition import", dependsOnMethods={"testAPIDefinitionUpdate"})
    public void testAPIDefinitionImport() throws Exception {
        String originalDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "oas_import.json"), (String)"UTF-8");
        String originalPublisherDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "oas_import_publisher.json"), (String)"UTF-8");
        String additionalProperties = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.resourcePath + "additionalProperties.json"), (String)"UTF-8");
        JSONObject additionalPropertiesObj = new JSONObject(additionalProperties);
        additionalPropertiesObj.put("provider", (Object)this.user.getUserName());
        File file = this.geTempFileWithContent(originalDefinition);
        APIDTO apidto = this.restAPIPublisher.importOASDefinition(file, additionalPropertiesObj.toString());
        this.apiImportId = apidto.getId();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiImportId, "Publish");
        String storeDefinition = this.restAPIStore.getSwaggerByID(this.apiImportId, this.user.getUserDomain());
        String publisherDefinition = this.restAPIPublisher.getSwaggerByID(this.apiImportId);
        this.validateDefinition(publisherDefinition);
        this.validateDefinition(storeDefinition);
        if (OAS_V2.equalsIgnoreCase(this.oasVersion)) {
            OAS2Utils.validateSwaggerDataInPublisher(apidto, publisherDefinition);
            OAS2Utils.validateSwaggerDataInStore(storeDefinition);
            OAS2Utils.validateUpdatedDefinition(originalPublisherDefinition, publisherDefinition);
            OAS2Utils.validateUpdatedDefinition(originalDefinition, storeDefinition);
            OAS2Utils.validateUpdatedDefinition(originalDefinition, apidto);
        } else {
            OAS3Utils.validateSwaggerDataInPublisher(apidto, publisherDefinition);
            OAS3Utils.validateSwaggerDataInStore(storeDefinition);
            OAS3Utils.validateUpdatedDefinition(originalPublisherDefinition, publisherDefinition);
            OAS3Utils.validateUpdatedDefinition(originalDefinition, storeDefinition);
            OAS3Utils.validateUpdatedDefinition(originalDefinition, apidto);
        }
    }

    private void testUpdatedAPIDefinitionInPublisher(APIDTO apidto, String oasVersion) throws Exception {
        String oasDefinition = this.restAPIPublisher.getSwaggerByID(this.apiId);
        this.validateDefinition(oasDefinition);
        if (OAS_V2.equalsIgnoreCase(oasVersion)) {
            OAS2Utils.validateOperationCount(apidto, oasDefinition);
            OAS2Utils.validateResourcesOfOASDefinition(apidto, oasDefinition);
            OAS2Utils.validateSwaggerDataInPublisher(apidto, oasDefinition);
        } else {
            OAS3Utils.validateOperationCount(apidto, oasDefinition);
            OAS3Utils.validateResourcesOfOASDefinition(apidto, oasDefinition);
            OAS3Utils.validateSwaggerDataInPublisher(apidto, oasDefinition);
        }
    }

    private void testUpdatedAPIDefinitionInStore(APIDTO apidto, String oasVersion) throws Exception {
        String oasDefinition = this.restAPIStore.getSwaggerByID(this.apiId, this.user.getUserDomain());
        this.validateDefinition(oasDefinition);
        if (OAS_V2.equalsIgnoreCase(oasVersion)) {
            OAS2Utils.validateOperationCount(apidto, oasDefinition);
            OAS2Utils.validateResourcesOfOASDefinition(apidto, oasDefinition);
            OAS2Utils.validateSwaggerDataInStore(oasDefinition);
        } else {
            OAS3Utils.validateOperationCount(apidto, oasDefinition);
            OAS3Utils.validateResourcesOfOASDefinition(apidto, oasDefinition);
            OAS3Utils.validateSwaggerDataInStore(oasDefinition);
        }
    }

    private void validateDefinition(String oasDefinition) throws Exception {
        File file = this.geTempFileWithContent(oasDefinition);
        OpenAPIDefinitionValidationResponseDTO responseDTO = this.restAPIPublisher.validateOASDefinition(file);
        Assert.assertTrue((boolean)responseDTO.isIsValid());
    }

    private File geTempFileWithContent(String swagger) throws Exception {
        File temp = File.createTempFile("swagger", ".json");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(swagger);
        out.close();
        return temp;
    }

    private void testDeleteApi(String apiId) throws Exception {
        if (apiId == null) {
            return;
        }
        this.restAPIPublisher.deleteAPI(apiId);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.testDeleteApi(this.apiId);
        this.testDeleteApi(this.apiImportId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN, OAS_V2}, {TestUserMode.SUPER_TENANT_ADMIN, OAS_V3}, {TestUserMode.TENANT_ADMIN, OAS_V2}, {TestUserMode.TENANT_ADMIN, OAS_V3}};
    }
}

