/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APICategoriesTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APICategoriesTestCase.class);
    private String publisherURLHttps;
    private String categoriesAdminAPIURL;
    private String categoryId;

    @Factory(dataProvider="userModeDataProvider")
    public APICategoriesTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttps();
        this.categoriesAdminAPIURL = this.publisherURLHttps + "api/am/admin/v0.16" + "/api-categories";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test add API category")
    public void testAddAPICategory() throws Exception {
        block15: {
            try (CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();){
                HttpPost post = new HttpPost(this.categoriesAdminAPIURL);
                post.addHeader("Authorization", "Basic " + APICategoriesTestCase.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
                post.addHeader("Content-Type", "application/json");
                StringEntity payload = new StringEntity("{\"name\": \"Marketing\", \"description\": \"Marketing category\"}", "UTF-8");
                payload.setContentType("application/json");
                post.setEntity((HttpEntity)payload);
                CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)201);
                HttpEntity entity = response.getEntity();
                if (entity == null) break block15;
                try {
                    String responsePayload = EntityUtils.toString((HttpEntity)entity);
                    JSONParser parser = new JSONParser();
                    JSONObject object = (JSONObject)parser.parse(responsePayload);
                    Assert.assertEquals((String)((String)object.get((Object)"name")), (String)"Marketing");
                    this.categoryId = (String)object.get((Object)"id");
                }
                finally {
                    response.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"wso2.am"}, description="Test add API category with duplicate name", dependsOnMethods={"testAddAPICategory"})
    public void addAPICategoryWithDuplicateName() throws Exception {
        try (CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();){
            HttpPost post = new HttpPost(this.categoriesAdminAPIURL);
            post.addHeader("Authorization", "Basic " + APICategoriesTestCase.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
            post.addHeader("Content-Type", "application/json");
            StringEntity payload = new StringEntity("{\"name\": \"Marketing\", \"description\": \"Marketing category\"}", "UTF-8");
            payload.setContentType("application/json");
            post.setEntity((HttpEntity)payload);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                HttpEntity entity = response.getEntity();
                String responsePayload = EntityUtils.toString((HttpEntity)entity);
                Assert.assertTrue((boolean)responsePayload.contains("Category with name 'Marketing' already exists"));
                Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)500);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test update API category", dependsOnMethods={"addAPICategoryWithDuplicateName"})
    public void testUpdateAPICategory() throws Exception {
        try (CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();){
            HttpPut put = new HttpPut(this.categoriesAdminAPIURL + "/" + this.categoryId);
            put.addHeader("Authorization", "Basic " + APICategoriesTestCase.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
            put.addHeader("Content-Type", "application/json");
            StringEntity payload = new StringEntity("{\"name\": \"Sales\", \"description\": \"Sales category\"}", "UTF-8");
            payload.setContentType("application/json");
            put.setEntity((HttpEntity)payload);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                HttpEntity entity = response.getEntity();
                Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test get API categories", dependsOnMethods={"testUpdateAPICategory"})
    public void testGetAPICategoriesFromAdminAPI() throws Exception {
        try (CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();){
            HttpGet get = new HttpGet(this.categoriesAdminAPIURL);
            get.addHeader("Authorization", "Basic " + APICategoriesTestCase.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
                HttpEntity entity = response.getEntity();
                String responsePayload = EntityUtils.toString((HttpEntity)entity);
                JSONParser parser = new JSONParser();
                JSONObject object = (JSONObject)parser.parse(responsePayload);
                int count = (int)((Long)object.get((Object)"count")).longValue();
                Assert.assertEquals((int)count, (int)1);
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Test delete API category", dependsOnMethods={"testGetAPICategoriesFromAdminAPI"})
    public void testDeleteAPICategory() throws Exception {
        try (CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();){
            HttpDelete delete = new HttpDelete(this.categoriesAdminAPIURL + "/" + this.categoryId);
            delete.addHeader("Authorization", "Basic " + APICategoriesTestCase.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)delete);){
                Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
            }
        }
    }

    private static String encodeCredentials(String user, char[] pass) {
        StringBuilder builder = new StringBuilder(user).append(':').append(pass);
        String cred = builder.toString();
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes());
        return new String(encodedBytes);
    }
}

