/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIEndpointTypeUpdateTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIEndpointTypeUpdateTestCase.class);
    private String APIVersion = "1.0.0";
    private String apiContext = "APIEndpointTypeUpdateTestCaseAPIContext";
    private String apiId;
    private String applicationID;
    private APIRequest apiRequest;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private URL endpointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIEndpointTypeUpdateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Sample API creation and subscribe")
    public void testAPICreation() {
        try {
            this.endpointUrl = new URL(this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add");
        }
        catch (MalformedURLException e) {
            this.log.error((Object)("Invalid URL " + this.endpointUrl), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
        try {
            String apiName = "APIEndpointTypeUpdateTestCaseAPIName";
            String description = "This is test API create by API manager integration test";
            String tags = "test, EndpointType";
            this.apiRequest = new APIRequest(apiName, this.apiContext, this.endpointUrl);
            this.apiRequest.setTags(tags);
            this.apiRequest.setDescription(description);
            this.apiRequest.setVersion(this.APIVersion);
            this.apiRequest.setProvider(this.publisherContext.getContextTenant().getContextUser().getUserName());
            String appName = "APIEndpointTypeUpdateTestCaseAPIApp";
            HttpResponse applicationResponse = this.restAPIStore.createApplication(appName, "This-is-test", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
            this.applicationID = applicationResponse.getData();
            this.apiId = this.createPublishAndSubscribeToAPIUsingRest(this.apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Gold");
            ArrayList<String> grantTypes = new ArrayList<String>();
            grantTypes.add("client_credentials");
            ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
            String accessToken = applicationKeyDTO.getToken().getAccessToken();
            this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while executing test case " + e.getMessage()), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"wso2.am"}, description="Invoke HTTP before Update", dependsOnMethods={"testAPICreation"})
    public void testHTTPTransportBeforeUpdate() {
        try {
            this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
            HttpResponse serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.apiContext, this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api http invocation");
            serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps(this.apiContext, this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api https invocation");
        }
        catch (Exception e) {
            this.log.error((Object)("Error while executing test case " + e.getMessage()), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTP transport and invoke", dependsOnMethods={"testHTTPTransportBeforeUpdate"})
    public void testUpdatedHTTPTransport() {
        try {
            this.apiRequest.setHttps_checked("");
            this.apiRequest.setHttp_checked("http");
            HttpResponse apiUpdateResponse = this.restAPIPublisher.updateAPI(this.apiRequest, this.apiId);
            Assert.assertEquals((int)apiUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
            this.waitForAPIDeployment();
            HttpResponse serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.apiContext, this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api http invocation");
            serviceResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttps(this.apiContext, this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api https invocation");
        }
        catch (Exception e) {
            this.log.error((Object)("Error while executing test case " + e.getMessage()), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(groups={"wso2.am"}, description="Update to only HTTPS transport and invoke", dependsOnMethods={"testHTTPTransportBeforeUpdate"})
    public void testUpdatedHTTPSTransport() {
        try {
            this.apiRequest.setHttps_checked("https");
            this.apiRequest.setHttp_checked("");
            HttpResponse apiUpdateResponse = this.restAPIPublisher.updateAPI(this.apiRequest, this.apiId);
            Assert.assertEquals((int)apiUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
            this.waitForAPIDeployment();
            HttpResponse serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp(this.apiContext, this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api http invocation");
            serviceResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttps(this.apiContext, this.APIVersion), this.requestHeaders);
            Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api https invocation");
        }
        catch (Exception e) {
            this.log.error((Object)("Error while executing test case " + e.getMessage()), (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationID);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO.getSubscriptionId());
        }
        this.restAPIStore.deleteApplication(this.applicationID);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

