/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM710AllSubscriptionsByApplicationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM710AllSubscriptionsByApplicationTestCase.class);
    private final String API_NAME = "SubscriptionByApplication";
    private final String API_NAME1 = "SubscriptionByApplication1";
    private final String API_CONTEXT = "SubscriptionByApplicationContext";
    private final String API_CONTEXT1 = "SubscriptionByApplicationContext1";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIRequest apiRequest;
    private ArrayList<String> applicationList = new ArrayList();
    private int listcount = 3;
    private ArrayList<String> apiList1 = new ArrayList();
    private ArrayList<String> apiList2 = new ArrayList();

    @Factory(dataProvider="userModeDataProvider")
    public APIM710AllSubscriptionsByApplicationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        HttpResponse createResponse;
        String tempApiContext;
        String tempApiName;
        int apiCount;
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        HttpResponse applicationResponse = this.restAPIStore.createApplication("app1", "app1", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationList.add(0, applicationResponse.getData());
        HttpResponse applicationResponse2 = this.restAPIStore.createApplication("app2", "app2", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationList.add(1, applicationResponse2.getData());
        for (apiCount = 0; apiCount < this.listcount; ++apiCount) {
            tempApiName = "SubscriptionByApplication" + apiCount;
            tempApiContext = "SubscriptionByApplicationContext" + apiCount;
            this.apiRequest = new APIRequest(tempApiName, tempApiContext, new URL(this.apiEndPointUrl));
            this.apiRequest.setVersion("1.0.0");
            this.apiRequest.setTiersCollection("Unlimited");
            this.apiRequest.setTier("Unlimited");
            this.apiRequest.setProvider(this.providerName);
            this.apiRequest.setTags("testTag1, testTag2, testTag3");
            this.apiRequest.setDescription("This is test API create by API manager integration test");
            createResponse = this.restAPIPublisher.addAPI(this.apiRequest);
            Assert.assertEquals((int)createResponse.getResponseCode(), (int)201, (String)"Error in API Creation");
            this.apiList1.add(apiCount, createResponse.getData());
            this.restAPIPublisher.changeAPILifeCycleStatus(createResponse.getData(), APILifeCycleAction.PUBLISH.getAction(), null);
            this.restAPIStore.createSubscription(createResponse.getData(), this.applicationList.get(0), "Unlimited");
        }
        for (apiCount = 0; apiCount < this.listcount; ++apiCount) {
            tempApiName = "SubscriptionByApplication1" + apiCount;
            tempApiContext = "SubscriptionByApplicationContext1" + apiCount;
            this.apiRequest = new APIRequest(tempApiName, tempApiContext, new URL(this.apiEndPointUrl));
            this.apiRequest.setVersion("1.0.0");
            this.apiRequest.setTiersCollection("Unlimited");
            this.apiRequest.setTier("Unlimited");
            this.apiRequest.setProvider(this.providerName);
            this.apiRequest.setTags("testTag1, testTag2, testTag3");
            this.apiRequest.setDescription("This is test API create by API manager integration test");
            createResponse = this.restAPIPublisher.addAPI(this.apiRequest);
            Assert.assertEquals((int)createResponse.getResponseCode(), (int)201, (String)"Error in API Creation");
            this.apiList2.add(apiCount, createResponse.getData());
            this.restAPIPublisher.changeAPILifeCycleStatus(createResponse.getData(), APILifeCycleAction.PUBLISH.getAction(), null);
            this.restAPIStore.createSubscription(createResponse.getData(), this.applicationList.get(1), "Unlimited");
        }
    }

    @Test(groups={"webapp"}, description="List all Subscriptions By Application Id")
    public void testGetAllSubscriptionsByAppId() throws Exception {
        SubscriptionListDTO subscriptionListDTO = this.restAPIStore.getSubscription(null, this.applicationList.get(0), null, null);
        int listCount1 = 0;
        int listCount2 = 0;
        for (SubscriptionDTO subscription : subscriptionListDTO.getList()) {
            for (String apiId : this.apiList1) {
                if (!apiId.equalsIgnoreCase(subscription.getApiId())) continue;
                ++listCount1;
            }
        }
        Assert.assertEquals((int)this.listcount, (int)listCount1, (String)"Application subscription count mismatch");
        SubscriptionListDTO subscriptionList1DTO = this.restAPIStore.getSubscription(null, this.applicationList.get(1), null, null);
        for (SubscriptionDTO subscription : subscriptionList1DTO.getList()) {
            for (String apiId : this.apiList2) {
                if (!apiId.equalsIgnoreCase(subscription.getApiId())) continue;
                ++listCount2;
            }
        }
        Assert.assertEquals((int)this.listcount, (int)listCount2, (String)"Application subscription count mismatch");
    }

    @Test(groups={"webapp"}, description="List all Subscriptions By API Id")
    public void testGetAllSubscriptionsByAPIId() throws Exception {
        for (String apiId : this.apiList1) {
            this.restAPIStore.createSubscription(apiId, this.applicationList.get(1), "Unlimited");
        }
        for (String apiId : this.apiList1) {
            SubscriptionListDTO subscriptionListDTO = this.restAPIStore.getSubscription(apiId, null, null, null);
            Assert.assertEquals((int)2, (int)subscriptionListDTO.getCount(), (String)("API subscription count mismatch" + apiId));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        for (String appId : this.applicationList) {
            this.restAPIStore.deleteApplication(appId);
        }
        for (String api : this.apiList1) {
            this.restAPIPublisher.deleteAPI(api);
        }
        for (String api : this.apiList2) {
            this.restAPIPublisher.deleteAPI(api);
        }
    }
}

