/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIMANAGER2611EndpointValidationTestCase
extends APIManagerLifecycleBaseTest {
    String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER2611EndpointValidationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="Validate endpoint with Http Head not support End point")
    public void checkEndpointValidation() throws Exception {
        String APIName = "APIMANAGER2611testAPI";
        String APIContext = "/testEndpointValid";
        String endPointToValidate = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(endPointToValidate));
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        this.apiId = this.restAPIPublisher.addAPI(apiRequest).getData();
        HttpResponse response = this.restAPIPublisher.checkValidEndpoint(endPointToValidate, this.apiId);
        int statusCode = response.getResponseCode();
        Assert.assertEquals((int)statusCode, (int)200, (String)"response code mismatched");
        String responseString = response.getData();
        Assert.assertTrue((boolean)responseString.contains("OK"), (String)("Invalid end point " + endPointToValidate + ":" + responseString));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

