/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIMANAGER4464BackendReturningStatusCode204TestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER4464BackendReturningStatusCode204TestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER4464BackendReturningStatusCode204TestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER}, {TestUserMode.TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
    }

    @Test(groups={"wso2.am"}, description="Send a request to a backend returning 204 and check if the expected result is received")
    public void testAPIReturningStatusCode204() throws Exception {
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        String apiName = "Test_API" + this.userMode;
        String apiVersion = "1.0.0";
        String apiContext = "/somecontext" + this.userMode;
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response204";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("Error creating APIRequest " + e.getMessage()));
            Assert.assertTrue((boolean)false);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + this.gatewayUrlsWrk.getWebAppURLNhttp() + "response"), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setResourceMethod("POST");
        try {
            apiRequest.setProvider(this.publisherContext.getContextTenant().getContextUser().getUserName());
            this.apiPublisher.addAPI(apiRequest);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.publisherContext.getContextTenant().getContextUser().getUserName(), APILifeCycleState.PUBLISHED);
            this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
            this.apiStore.addApplication("APP", "Unlimited", "", "");
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, this.storeContext.getContextTenant().getContextUser().getUserName(), "APP", "Unlimited");
            this.apiStore.subscribe(subscriptionRequest);
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("APP");
            String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject response = new JSONObject(responseString);
            String accessToken = response.getJSONObject("data").getJSONObject("key").getString("accessToken");
            String apiInvocationUrl = this.userMode == TestUserMode.TENANT_ADMIN || this.userMode == TestUserMode.TENANT_USER ? this.gatewayUrlsWrk.getWebAppURLNhttp() + "/t/wso2.com" + apiContext + "/" + apiVersion : this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + "/" + apiVersion;
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost post = new HttpPost(apiInvocationUrl);
            post.addHeader((Header)new BasicHeader("Authorization", "Bearer " + accessToken));
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)post);
            Assert.assertEquals((int)httpResponse.getStatusLine().getStatusCode(), (int)204, (String)"Status Code is not 204");
        }
        catch (JSONException e) {
            log.error((Object)("Error parsing JSON to get access token " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("XPathExpressionException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            log.error((Object)("IOException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

