/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.TagDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.TagListDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APISearchAPIByTagTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APISearchAPIByTagTestCase.class);
    private final String API_NAME_1 = "APISearchAPIByTagAPIName_1";
    private final String API_NAME_2 = "APISearchAPIByTagAPIName_2";
    private final String API_CONTEXT_1 = "PISearchAPIByTagContext_1";
    private final String API_CONTEXT_2 = "PISearchAPIByTagContext_2";
    private final String TAG_API_1 = "api_1_tag";
    private final String TAG_API_2 = "api_2_tag";
    private final String TAG_API = "api_common_tag";
    private final String API_NAME_CONTEXT_UPPER_CASE = "apiNameContextUpperCaseTag";
    private final String API_NAME_CONTEXT_LOWER_CASE = "apiNameContextLowerCaseTag";
    private final String API_NAME_CONTEXT_WITH_SPACE = "apiNameContextWithSpaceTag";
    private final String API_NAME_CONTEXT_WITHOUT_SPACE = "apiNameContextWithoutSpaceTag";
    private final String TAG_GROUP_UPPER_CASE = "API_tag-group";
    private final String TAG_GROUP_LOWER_CASE = "api_tag-group";
    private final String TAG_GROUP_WITH_SPACE = "api tag-group";
    private final String TAG_GROUP_WITHOUT_SPACE = "apiTag-group";
    private final String TAG_NOT_EXIST = "no_such_tag";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private static final long WAIT_TIME = 45000L;
    private APIRequest apiRequest;
    private String tags;
    private String tierCollection;
    private String endpointUrl;
    String providerName = "";

    @Factory(dataProvider="userModeDataProvider")
    public APISearchAPIByTagTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.tierCollection = "Bronze,Gold,Silver,Unlimited";
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        this.tags = "api_common_tag,api_1_tag";
        this.apiRequest = new APIRequest("APISearchAPIByTagAPIName_1", "PISearchAPIByTagContext_1", new URL(this.endpointUrl));
        this.apiRequest.setTags(this.tags);
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setTiersCollection(this.tierCollection);
        this.apiRequest.setProvider(this.providerName);
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/add");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        this.apiRequest.setOperationsDTOS(operationsDTOS);
        this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.tags = "api_common_tag,api_2_tag";
        this.apiRequest = new APIRequest("APISearchAPIByTagAPIName_2", "PISearchAPIByTagContext_2", new URL(this.endpointUrl));
        this.apiRequest.setTags(this.tags);
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setTiersCollection(this.tierCollection);
        this.apiRequest.setProvider(this.providerName);
        apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/add");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        operationsDTOS = new ArrayList();
        operationsDTOS.add(apiOperationsDTO1);
        this.apiRequest.setOperationsDTOS(operationsDTOS);
        this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APISearchAPIByTagAPIName_2", "1.0.0", "\"isApiExists\":true");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @Test(groups={"wso2.am"}, description="API search by TAG", dependsOnMethods={"testAPICreation"})
    public void testAPISearchByTag() throws Exception {
        this.watForAPIsAvailableOnSearchApi();
        String searchTerm = "tags:api_common_tag";
        APIListDTO response = this.restAPIStore.searchPaginatedAPIs(10, 0, this.user.getUserDomain(), searchTerm);
        Assert.assertEquals((int)response.getList().size(), (int)2, (String)"Search API return invalid APIs");
        int expectedAPIs = 0;
        for (APIInfoDTO api : response.getList()) {
            if (!api.getName().equals("APISearchAPIByTagAPIName_1") && !api.getName().equals("APISearchAPIByTagAPIName_2")) continue;
            ++expectedAPIs;
        }
        Assert.assertTrue((expectedAPIs == 2 ? 1 : 0) != 0, (String)"API with searched tag not returned");
        searchTerm = "tags:api_1_tag";
        response = this.restAPIStore.searchPaginatedAPIs(10, 0, this.user.getUserDomain(), searchTerm);
        Assert.assertEquals((int)response.getList().size(), (int)1, (String)"Search API return invalid APIs");
        for (APIInfoDTO api : response.getList()) {
            Assert.assertTrue((boolean)api.getName().equals("APISearchAPIByTagAPIName_1"), (String)"API with searched tag not returned");
        }
        for (APIInfoDTO api : response.getList()) {
            Assert.assertFalse((boolean)api.getName().equals("APISearchAPIByTagAPIName_2"), (String)"Result contain API without the requested Tag");
        }
        searchTerm = "tags:no_such_tag";
        response = this.restAPIStore.searchPaginatedAPIs(10, 0, this.user.getUserDomain(), searchTerm);
        Assert.assertNull((Object)response, (String)"Search API return invalid APIs");
    }

    @Test(groups={"wso2.am"}, description="API search by group TAG", dependsOnMethods={"testAPISearchByTag"})
    public void testAPISearchByTagGroup() throws Exception {
        String[] tt;
        this.apiRequest = new APIRequest("apiNameContextUpperCaseTag", "apiNameContextUpperCaseTag", new URL(this.endpointUrl));
        this.apiRequest.setTags("API_tag-group");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setTiersCollection(this.tierCollection);
        this.apiRequest.setProvider(this.providerName);
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/add");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        this.apiRequest.setOperationsDTOS(operationsDTOS);
        this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextUpperCaseTag", "1.0.0", "\"isApiExists\":true");
        this.watForTagsAvailableOnSearchApi("API_tag-group");
        this.apiRequest = new APIRequest("apiNameContextLowerCaseTag", "apiNameContextLowerCaseTag", new URL(this.endpointUrl));
        this.apiRequest.setTags("api_tag-group");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setTiersCollection(this.tierCollection);
        this.apiRequest.setProvider(this.providerName);
        apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/add");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        operationsDTOS = new ArrayList();
        operationsDTOS.add(apiOperationsDTO1);
        this.apiRequest.setOperationsDTOS(operationsDTOS);
        this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextLowerCaseTag", "1.0.0", "\"isApiExists\":true");
        this.watForTagsAvailableOnSearchApi("api_tag-group");
        this.apiRequest = new APIRequest("apiNameContextWithSpaceTag", "apiNameContextWithSpaceTag", new URL(this.endpointUrl));
        this.apiRequest.setTags("api tag-group");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setTiersCollection(this.tierCollection);
        this.apiRequest.setProvider(this.providerName);
        apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/add");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        operationsDTOS = new ArrayList();
        operationsDTOS.add(apiOperationsDTO1);
        this.apiRequest.setOperationsDTOS(operationsDTOS);
        this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextWithSpaceTag", "1.0.0", "\"isApiExists\":true");
        this.watForTagsAvailableOnSearchApi("api tag-group");
        this.apiRequest = new APIRequest("apiNameContextWithoutSpaceTag", "apiNameContextWithoutSpaceTag", new URL(this.endpointUrl));
        this.apiRequest.setTags("apiTag-group");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setTiersCollection(this.tierCollection);
        this.apiRequest.setProvider(this.providerName);
        apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/add");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        operationsDTOS = new ArrayList();
        operationsDTOS.add(apiOperationsDTO1);
        this.apiRequest.setOperationsDTOS(operationsDTOS);
        this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "apiNameContextWithoutSpaceTag", "1.0.0", "\"isApiExists\":true");
        this.watForTagsAvailableOnSearchApi("apiTag-group");
        TagListDTO tagListDTO = this.restAPIStore.getAllTags();
        this.log.info((Object)("All tags before assert: " + tagListDTO.toString()));
        List tagList = tagListDTO.getList();
        for (String t : tt = new String[]{"API_tag-group", "api_tag-group", "api tag-group", "apiTag-group"}) {
            boolean found = false;
            for (TagDTO tag : tagList) {
                if (!t.equals(tag.getValue())) continue;
                Assert.assertEquals((int)tag.getCount(), (int)1);
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found, (String)("Tag " + t + " is not available on tag cloud"));
        }
    }

    public void watForAPIsAvailableOnSearchApi() throws Exception {
        String searchTerm = "";
        long waitTime = System.currentTimeMillis() + 45000L;
        while (waitTime > System.currentTimeMillis()) {
            APIListDTO apiList = this.restAPIStore.searchPaginatedAPIs(10, 0, this.user.getUserDomain(), searchTerm);
            this.log.info((Object)"WAIT for availability of API : APISearchAPIByTagAPIName_1 and APISearchAPIByTagAPIName_2 found on Store search API");
            if (apiList == null) continue;
            this.log.info((Object)("APIs Count: " + apiList.getCount()));
            int returnCount = 0;
            for (APIInfoDTO apiInfo : apiList.getList()) {
                if (apiInfo.getName().contains("APISearchAPIByTagAPIName_1")) {
                    ++returnCount;
                }
                if (!apiInfo.getName().contains("APISearchAPIByTagAPIName_2")) continue;
                ++returnCount;
            }
            if (returnCount == 2) {
                this.log.info((Object)"API :APISearchAPIByTagAPIName_1 and APISearchAPIByTagAPIName_2 found");
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void watForTagsAvailableOnSearchApi(String tag) throws Exception {
        long waitTime = System.currentTimeMillis() + 45000L;
        boolean found = false;
        while (waitTime > System.currentTimeMillis()) {
            TagListDTO tagsList = this.restAPIStore.getAllTags();
            this.log.info((Object)("WAIT for availability of tags : " + tag + " found on Store tag cloud"));
            if (tagsList == null) continue;
            this.log.info((Object)("Data: " + tagsList.toString()));
            if (tagsList.toString().contains(tag)) {
                this.log.info((Object)("Tag :" + tag + " found"));
                found = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertTrue((boolean)found, (String)(tag + " :Tag was not found"));
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

