/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APISecurityAuditTestCase
extends APIManagerLifecycleBaseTest {
    private final String AUDIT_API_NAME = "TestAuditAPI";
    private final String API_CONTEXT = "audit";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String ENDPOINT_URL = "https://localhost:9943/am-auditApi-sample/api/auditapi";
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APISecurityAuditTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="get security audit report for api")
    public void testGetAuditAPI() throws Exception {
        String description = "This is a test API created by API manager integration test for API Security Audit";
        APIRequest apiRequest = new APIRequest("TestAuditAPI", "audit", new URL("https://localhost:9943/am-auditApi-sample/api/auditapi"));
        apiRequest.setDescription(description);
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "TestAuditAPI", "1.0.0", "\"isApiExists\":true");
        HttpResponse auditReportResponse = this.restAPIPublisher.getAuditApi(this.apiId);
        AssertJUnit.assertNotNull((Object)auditReportResponse);
        Assert.assertEquals((int)auditReportResponse.getResponseCode(), (int)200);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

