/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;

public class RelativeUrlLocationHeaderTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(RelativeUrlLocationHeaderTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="Check functionality of the API for relative URL location header")
    public void testAPIWithRelativeUrlLocationHeader() throws Exception {
        String endpointUrl = this.getAPIInvocationURLHttp("response_loc") + "/1.0.0";
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet get = new HttpGet(endpointUrl);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)httpResponse.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        Assert.assertTrue((boolean)httpResponse.getFirstHeader("Location").getValue().contains("/abc/domain"), (String)"Location Header not received.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

