/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM18CreateAnAPIThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM18PublisherTest";
    private final String apiVersion = "1.0.0";
    private String apiProviderName;
    private String apiProductionEndPointUrl;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIM18CreateAnAPIThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API")
    public void testCreateAnAPIThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim18PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag18-1, tag18-2, tag18-3";
        APIRequest apiCreationRequestBean = new APIRequest("APIM18PublisherTest", apiContextTest, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setVersion("1.0.0");
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setTier("Gold");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/customers/{id}");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        apiCreationRequestBean.setDefault_version_checked("true");
        apiCreationRequestBean.setBusinessOwner("api18b");
        apiCreationRequestBean.setBusinessOwnerEmail("api18b@ee.com");
        apiCreationRequestBean.setTechnicalOwner("api18t");
        apiCreationRequestBean.setTechnicalOwnerEmail("api18t@ww.com");
        apiCreationRequestBean.setOperationsDTOS(operationsDTOS);
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        this.apiId = apiCreationResponse.getData();
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertTrue((boolean)response.getData().contains("APIM18PublisherTest"), (String)"Invalid API Name");
        Assert.assertTrue((boolean)response.getData().contains("1.0.0"), (String)"Invalid API Version");
        Assert.assertTrue((boolean)response.getData().contains(apiContextTest), (String)"Invalid API Context");
    }

    @Test(groups={"wso2.am"}, description="Remove an API Through the Publisher Rest API", dependsOnMethods={"testCreateAnAPIThroughThePublisherRest"})
    public void testRemoveAnAPIThroughThePublisherRest() throws Exception {
        HttpResponse removeApiResponse = this.restAPIPublisher.deleteAPI(this.apiId);
        Assert.assertEquals((int)removeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when removing an API");
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.NOT_FOUND.getStatusCode(), (String)"Status code mismatch");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        super.cleanUp();
    }
}

