/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM534GetAllTheAPIsCreatedThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM534GetAllTheAPIsCreatedThroughThePublisherRestAPITestCase.class);
    private static final String apiNameTest1 = "APIM534PublisherTest1";
    private static final String apiNameTest2 = "APIM534PublisherTest2";
    private static final String apiNameTest3 = "APIM534PublisherTest3";
    private static final String apiVersion = "1.0.0";
    private static String apiProviderName;
    private static String apiTest1EndPointUrl;
    private static String apiTest2EndPointUrl;
    private static String apiTest3EndPointUrl;
    private static String id;
    List<String> idList = new ArrayList<String>();

    @Factory(dataProvider="userModeDataProvider")
    public APIM534GetAllTheAPIsCreatedThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @DataProvider(name="createAPI")
    public static Object[][] createAppWithValidDataProvider() throws Exception {
        return new Object[][]{{apiNameTest1, "apim534PublisherTest1API", apiVersion, apiProviderName, new URL(apiTest1EndPointUrl)}, {apiNameTest2, "apim534PublisherTest2API", apiVersion, apiProviderName, new URL(apiTest2EndPointUrl)}, {apiNameTest3, "apim534PublisherTest3API", apiVersion, apiProviderName, new URL(apiTest3EndPointUrl)}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiTest1EndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String apiTest2EndpointPostfixUrl = "name-check1/";
        String apiTest3EndpointPostfixUrl = "pizzashack-api-1.0.0/api/";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        apiTest1EndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiTest1EndpointPostfixUrl;
        apiTest2EndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiTest2EndpointPostfixUrl;
        apiTest3EndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiTest3EndpointPostfixUrl;
        apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(dataProvider="createAPI", description="Create an API using valid data and get all the API through Publisher Rest API")
    public void testGetAllTheAPICreatedThroughThePublisherRestAPI(String apiName, String context, String version, String provider, URL endpointUrl) throws Exception {
        APIRequest apiRequest = new APIRequest(apiName, context, endpointUrl);
        apiRequest.setVersion(version);
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiRequest);
        id = apiCreationResponse.getData();
        org.testng.Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertNotNull((String)id, (Object)"APIs are not created as expected");
        this.idList.add(id);
        HttpResponse resp = this.restAPIPublisher.getAPI(id);
        org.testng.Assert.assertEquals((int)resp.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"API does not exist");
        List<String> apiList = Arrays.asList(apiNameTest1, apiNameTest2, apiNameTest3);
        log.info((Object)("My API List :" + apiList));
        Thread.sleep(5000L);
        APIListDTO response = this.restAPIPublisher.getAllAPIs();
        JSONObject jsonObject = new JSONObject((Object)response);
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        ArrayList<String> allApiList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            String name = jsonArray.getJSONObject(i).getString("name");
            allApiList.add(name);
        }
        log.info((Object)("All API List :" + allApiList));
    }

    @Test(groups={"wso2.am"}, description="Validate if an API exists through the publisher REST API", dependsOnMethods={"testGetAllTheAPICreatedThroughThePublisherRestAPI"})
    public void testCheckIfAnAPIExistsThroughThePublisherRestAPI() throws Exception {
        APIRequest apiRequest = new APIRequest(apiNameTest1, "apim534PublisherTest1API", new URL(apiTest1EndPointUrl));
        apiRequest.setVersion(apiVersion);
        HttpResponse response = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertNull((String)"Added same api again", (Object)response);
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        for (String id : this.idList) {
            this.restAPIPublisher.deleteAPI(id);
        }
        super.cleanUp();
    }
}

