/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM574ChangeTheStatusOfAnAPIToPrototypedThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM574PublisherTest";
    private final String apiVersion = "1.0.0";
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIM574ChangeTheStatusOfAnAPIToPrototypedThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API throgh the publisher rest API ")
    public void testCreateAnAPIThroughThePublisherRest() throws Exception {
        String apiContext = "apim574PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag574-1, tag574-2, tag587-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM574PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api574b");
        apiCreationRequestBean.setBizOwnerMail("api574b@ee.com");
        apiCreationRequestBean.setTechOwner("api574t");
        apiCreationRequestBean.setTechOwnerMail("api574t@ww.com");
        APIDTO apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        String status = apiCreationResponse.getLifeCycleStatus();
        this.apiId = apiCreationResponse.getId();
        HttpResponse apiResponsePublisher = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)apiResponsePublisher.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)"APIM574PublisherTest".equals(apiCreationResponse.getName()), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)APILifeCycleState.CREATED.getState().equalsIgnoreCase(status), (String)"Status of the APIM574PublisherTestis not a valid status");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to PROTOTYPED through the publisher rest API ", dependsOnMethods={"testCreateAnAPIThroughThePublisherRest"})
    public void testChangeTheStatusOfTheAPIToPrototyped() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEPLOY_AS_PROTOTYPE.getAction());
        Assert.assertTrue((boolean)APILifeCycleState.PROTOTYPED.getState().equals(this.restAPIPublisher.getLifecycleStatus(this.apiId).getData()), (String)"APIM574PublisherTest  status not updated as Prototyped");
        HttpResponse prototypedApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)prototypedApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)prototypedApiResponse.getData().contains("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to PUBLISHED through the publisher rest API ", dependsOnMethods={"testChangeTheStatusOfTheAPIToPrototyped"})
    public void testChangeTheStatusOfTheAPIToPublished() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        Assert.assertTrue((boolean)APILifeCycleState.PUBLISHED.getState().equals(this.restAPIPublisher.getLifecycleStatus(this.apiId).getData()), (String)"APIM574PublisherTeststatus not updated as Published");
        HttpResponse publishedApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)publishedApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)publishedApiResponse.getData().contains("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to DEPRECATED through the publisher rest API ", dependsOnMethods={"testChangeTheStatusOfTheAPIToPublished"})
    public void testChangeTheStatusOfTheAPIToDeprecated() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEPRECATE.getAction());
        Assert.assertTrue((boolean)APILifeCycleState.DEPRECATED.getState().equals(this.restAPIPublisher.getLifecycleStatus(this.apiId).getData()), (String)"APIM574PublisherTest  status not updated as Deprecate");
        HttpResponse deprecatedApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)deprecatedApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)deprecatedApiResponse.getData().contains("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to RETIRED through the publisher rest API ", dependsOnMethods={"testChangeTheStatusOfTheAPIToDeprecated"})
    public void testChangeTheStatusOfTheAPIToRetired() throws Exception {
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.RETIRE.getAction());
        Assert.assertTrue((boolean)APILifeCycleState.RETIRED.getState().equals(this.restAPIPublisher.getLifecycleStatus(this.apiId).getData()), (String)"APIM574PublisherTeststatus not updated as Retired");
        HttpResponse retiredApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        Assert.assertEquals((int)retiredApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)retiredApiResponse.getData().contains("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

