/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIM638ValidateTheRoleOfAnExistingUserThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String adminRole = "carbonAdmin";
    private final String creatorRole = "creator";
    private final String publisherRole = "publisher";
    private String publisherBackEndUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM638ValidateTheRoleOfAnExistingUserThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String permissionListApiLogin = "/permission/admin/login";
        String permissionListApiManage = "/permission/admin/manage/api";
        String permissionListApiCreate = "/permission/admin/manage/api/create";
        String permissionListApiPublish = "/permission/admin/manage/api/publish";
        this.publisherBackEndUrl = this.publisherContext.getContextUrls().getBackEndUrl();
        UserManagementClient userManagementClientAdmin = new UserManagementClient(this.publisherBackEndUrl, this.createSession(this.publisherContext));
        userManagementClientAdmin.addRole("carbonAdmin", new String[0], new String[]{permissionListApiLogin, permissionListApiManage, permissionListApiCreate, permissionListApiPublish});
        userManagementClientAdmin.addRole("creator", new String[0], new String[]{permissionListApiLogin, permissionListApiCreate});
    }

    @Test(groups={"wso2.am"}, description="Validate the Role of an existing user through the publisher rest API ")
    public void testValidateTheRoleOfAnExistingUser() throws Exception {
        ApiResponse apiResponse = this.restAPIPublisher.validateRoles("carbonAdmin");
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200, (String)"Response code mismatch for: carbonAdmin");
        apiResponse = this.restAPIPublisher.validateRoles("creator");
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200, (String)"Response code mismatch for: creator");
    }

    @Test(groups={"wso2.am"}, description="Validate the Role of an non-existing user through the publisher rest API ", dependsOnMethods={"testValidateTheRoleOfAnExistingUser"})
    public void testValidateTheRoleOfAnNonExistingUser() throws Exception {
        try {
            this.restAPIPublisher.validateRoles("publisher");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404, (String)"User already exists for publisher");
        }
    }

    @AfterClass(alwaysRun=true)
    public void clearRoles() throws Exception {
        UserManagementClient userManagementClientAdmin = new UserManagementClient(this.publisherBackEndUrl, this.createSession(this.publisherContext));
        userManagementClientAdmin.deleteRole("carbonAdmin");
        userManagementClientAdmin.deleteRole("creator");
        super.cleanUp();
    }
}

