/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.resources;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIResourceModificationTestCase
extends APIMIntegrationBaseTest {
    private String APIName = "APIResourceTestAPI";
    private String APIVersion = "1.0.0";
    private String providerName = "";
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIResourceModificationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.providerName = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="add scope to resource test case")
    public void testSetScopeToResourceTestCase() throws Exception {
        String APIContext = "testResAPI";
        String tags = "youtube, video, media";
        String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
        String description = "This is test API create by API manager integration test";
        APIRequest apiRequest = new APIRequest(this.APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(this.APIVersion);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiRequest.setProvider(this.providerName);
        HttpResponse httpResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = httpResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        HttpResponse publishedApiResponse = this.restAPIPublisher.getAPI(this.apiId);
        org.testng.Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)publishedApiResponse.getResponseCode(), (String)(this.APIName + " is not visible in publisher"));
        String oldSwagger = this.restAPIPublisher.getSwaggerByID(this.apiId);
        String modifiedResource = "{\n    \"swagger\": \"2.0\",\n    \"paths\": {\n        \"/*\": {\n            \"get\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"post\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"parameters\": [\n                    {\n                        \"name\": \"Payload\",\n                        \"description\": \"Request Body\",\n                        \"required\": false,\n                        \"in\": \"body\",\n                        \"schema\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"payload\": {\n                                    \"type\": \"string\"\n                                }\n                            }\n                        }\n                    }\n                ],\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"put\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"parameters\": [\n                    {\n                        \"name\": \"Payload\",\n                        \"description\": \"Request Body\",\n                        \"required\": false,\n                        \"in\": \"body\",\n                        \"schema\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"payload\": {\n                                    \"type\": \"string\"\n                                }\n                            }\n                        }\n                    }\n                ],\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"delete\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"patch\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"parameters\": [\n                    {\n                        \"name\": \"Payload\",\n                        \"description\": \"Request Body\",\n                        \"required\": false,\n                        \"in\": \"body\",\n                        \"schema\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"payload\": {\n                                    \"type\": \"string\"\n                                }\n                            }\n                        }\n                    }\n                ],\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            }\n        }\n    },\n    \"info\": {\n        \"title\": \"APIResourceTestAPI\",\n        \"version\": \"1.0.0\"\n    }\n}";
        String swaggerResponse = this.restAPIPublisher.updateSwagger(this.apiId, modifiedResource);
        AssertJUnit.assertNotNull((Object)swaggerResponse);
        String updatedSwagger = this.restAPIPublisher.getSwaggerByID(this.apiId);
        Assert.assertNotEquals((String)updatedSwagger, (Object)oldSwagger, (Object)"Modifying resources failed for API");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

