/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.samples;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class PizzaShackAPITestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private APICreationRequestBean resorcet;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Pizzashack Test")
    public void testPizzashackApiSample() throws Exception {
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("PizzaAPI", "pizzashack", "1.0.0", "admin", new URL("http://localhost:9766/pizzashack-api-1.0.0/api/"));
        apiCreationRequestBean.setThumbUrl("/home/bhagya/WS/Pizza_Shack_Logo.jpeg");
        apiCreationRequestBean.setDescription("Pizza API:Allows to manage pizza orders (create, update, retrieve orders)");
        apiCreationRequestBean.setTags("pizza, order, pizza-menu");
        apiCreationRequestBean.setResourceCount("4");
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/menu"));
        resourceBeanList.add(new APIResourceBean("POST", "Application & Application User", "Unlimited", "/order"));
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/order/{orderid}"));
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/delivery"));
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        this.apiPublisher.addAPI(apiCreationRequestBean);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("PizzaAPI", this.publisherContext.getContextTenant().getContextUser().getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.addApplication("PizzaShack", "Unlimited", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("PizzaAPI", this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName("PizzaShack");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("PizzaShack");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        Thread.sleep(2000L);
        HttpResponse pizzaShackResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "pizzashack/1.0.0/menu"), requestHeaders);
        Assert.assertEquals((int)pizzaShackResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        System.out.println("My Response Code is " + pizzaShackResponse.getResponseCode());
        Assert.assertTrue((boolean)pizzaShackResponse.getData().contains("BBQ Chicken Bacon"), (String)"Response data mismatched when api invocation");
        Assert.assertTrue((boolean)pizzaShackResponse.getData().contains("Grilled white chicken"), (String)"Response data mismatched when api invocation");
        Assert.assertTrue((boolean)pizzaShackResponse.getData().contains("Chicken Parmesan"), (String)"Response data mismatched when api invocation");
        Assert.assertTrue((boolean)pizzaShackResponse.getData().contains("Tuscan Six Cheese"), (String)"Response data mismatched when api invocation");
        Assert.assertTrue((boolean)pizzaShackResponse.getData().contains("Asiago and Fontina"), (String)"Response data mismatched when api invocation");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("PizzaShack");
        super.cleanUp();
    }
}

