/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.samples;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class YouTubeAPITestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String gatewayUrl;

    @Factory(dataProvider="userModeDataProvider")
    public YouTubeAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.gatewayUrl = this.getAPIInvocationURLHttp("");
    }

    @Test(groups={"wso2.am"}, description="You Tube other")
    public void testYouTubeApiSample() throws Exception {
        APIRequest apiRequest = new APIRequest("YoutubeFeeds", "youtube", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("YoutubeFeeds", this.publisherContext.getContextTenant().getContextUser().getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.addApplication("YoutubeFeeds-Application", "Gold", "", "this-is-test");
        String provider = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("YoutubeFeeds", provider);
        subscriptionRequest.setApplicationName("YoutubeFeeds-Application");
        subscriptionRequest.setTier("Gold");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("YoutubeFeeds-Application");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)(this.gatewayUrl + "youtube/1.0.0/most_popular"), requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<feed"), (String)"Response data mismatched when api invocation");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<category"), (String)"Response data mismatched when api invocation");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<entry>"), (String)"Response data mismatched when api invocation");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("YoutubeFeeds-Application");
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

