/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class HardThrottlingTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private ServerConfigurationManager serverConfigurationManager;
    private String publisherURLHttp;
    private String storeURLHttp;
    private static final Log log = LogFactory.getLog(HardThrottlingTestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public HardThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.serverConfigurationManager = new ServerConfigurationManager(new AutomationContext("APIM", "gateway-wrk", TestUserMode.SUPER_TENANT_ADMIN));
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Token API Test sample")
    public void testProductionLimit() throws Exception {
        String apiName = "HardThrottleTestAPI";
        String apiContext = "throttle";
        String tags = "throttle";
        String url = this.gatewayUrlsWrk.getWebAppURLNhttp() + "stockquote";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String apiVersion = "1.0.0";
        String applicationName = "HardThrottleTestApplication";
        String keyType = "PRODUCTION";
        int requestLimit = 5;
        this.apiPublisher.login(this.publisherContext.getSuperTenant().getContextUser().getUserName(), this.publisherContext.getSuperTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.addParameter("productionTps", Integer.toString(requestLimit));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(apiVersion);
        apiRequest.setSandbox(url);
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.login(this.publisherContext.getSuperTenant().getContextUser().getUserName(), this.publisherContext.getSuperTenant().getContextUser().getPassword());
        this.apiStore.addApplication(applicationName, "Gold", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, this.publisherContext.getSuperTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName(applicationName);
        subscriptionRequest.setTier("Gold");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequestProduction = new APPKeyRequestGenerator(applicationName);
        generateAppKeyRequestProduction.setKeyType(keyType);
        String responseStringProduction = this.apiStore.generateApplicationKey(generateAppKeyRequestProduction).getData();
        JSONObject responseSandBOX = new JSONObject(responseStringProduction);
        String productionAccessToken = responseSandBOX.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeadersProduction = new HashMap<String, String>();
        requestHeadersProduction.put("Authorization", "Bearer " + productionAccessToken);
        for (int accessCount = 0; accessCount < requestLimit + 1; ++accessCount) {
            HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + apiVersion), requestHeadersProduction);
        }
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + apiContext + apiVersion), requestHeadersProduction);
        log.info((Object)("Response : " + youTubeResponseSandBox.getData()));
        log.info((Object)("Response Status: " + youTubeResponseSandBox.getResponseCode()));
        Assert.assertEquals((int)youTubeResponseSandBox.getResponseCode(), (int)503, (String)"Response code mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        this.serverConfigurationManager.restoreToLastConfiguration();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

