/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class JWTBandwidthThrottlingTestCase
extends APIMIntegrationBaseTest {
    private AdminDashboardRestClient adminDashboardRestClient;
    private String appPolicyName = "AppPolicyWithBandwidth";
    private String subPolicyName = "SubPolicyWithBandwidth";
    private String apiPolicyName = "APIPolicyWithBandwidth";
    private String apiId;
    private String gatewayUrl;
    private String app1Id;
    private String app2Id;
    private String backendEP;
    private String body = "{\"payload\" : \"000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\"}";
    private String app3Id;
    private static final Log log = LogFactory.getLog(JWTBandwidthThrottlingTestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public JWTBandwidthThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminDashboardRestClient = new AdminDashboardRestClient(this.getPublisherURLHttps());
        this.adminDashboardRestClient.login(this.user.getUserName(), this.user.getPassword());
        HttpResponse addPolicyResponse = this.adminDashboardRestClient.addApplicationPolicyWithBandwidthType(this.appPolicyName, 1, "KB", 1, "min");
        this.verifyResponse(addPolicyResponse);
        addPolicyResponse = this.adminDashboardRestClient.addSubscriptionPolicyWithBandwidthType(this.subPolicyName, 1, "KB", 1, "min", true, 100, "min");
        this.verifyResponse(addPolicyResponse);
        String throttlingPolicyJSON = "{\"policyName\":\"" + this.apiPolicyName + "\",\"policyDescription\":\"\",\"executionFlows\":[],\"defaultQuotaPolicy\":{\"type\":\"bandwidthVolume\",\"limit\":{\"requestCount\":0,\"timeUnit\":\"min\",\"dataAmount\":\"1\",\"dataUnit\":\"KB\",\"unitTime\":\"1\"}}}";
        addPolicyResponse = this.adminDashboardRestClient.addThrottlingPolicy(throttlingPolicyJSON);
        this.verifyResponse(addPolicyResponse);
        this.backendEP = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response/";
        String APIName = "BandwidthTestAPI";
        String APIContext = "bandwithtestapi";
        String tags = "youtube, token, media";
        String url = this.backendEP;
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setTiersCollection("Unlimited," + this.subPolicyName);
        ArrayList<APIOperationsDTO> operations = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("POST");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTO.setAuthType("Application & Application User");
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        operations.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operations);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), APIName, APIVersion, "\"isApiExists\":true");
        this.gatewayUrl = this.getAPIInvocationURLHttps(APIContext + "/" + APIVersion + "/");
        HashMap requestHeaders = new HashMap();
        HttpResponse response = HttpRequestUtil.doGet((String)this.backendEP, requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Backend (dummy_api.xml) is not up and running");
    }

    @Test(groups={"wso2.am"}, description="")
    public void testApplicationLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("ApplicationBandwidthtestapp", this.appPolicyName, "", "this-is-test");
        this.app1Id = applicationDTO.getApplicationId();
        Assert.assertEquals((boolean)true, (boolean)applicationDTO.getThrottlingPolicy().equals(this.appPolicyName));
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Unlimited"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        JSONObject jwtObject = new JSONObject(jwtString);
        log.info((Object)("Decoded JWT token: " + jwtString));
        JSONObject tierInfo = (JSONObject)jwtObject.get("application");
        Assert.assertEquals((boolean)tierInfo.has("tierQuotaType"), (boolean)true, (String)"tierQuotaType property does not exist in the JWT");
        Assert.assertEquals((Object)tierInfo.get("tierQuotaType"), (Object)"bandwidthVolume", (String)"tierQuotaType property does not match 'bandwidthVolume' in the JWT");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.gatewayUrl, requestHeaders, (String)this.body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by bandwidth condition in application tier");
    }

    @Test(groups={"wso2.am"}, description="")
    public void testSubscriptionLevelThrottling() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("SubscriptionBandwidthtestapp", "Unlimited", "", "this-is-test");
        this.app2Id = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), this.subPolicyName);
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals(this.subPolicyName));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String jwtString = APIMTestCaseUtils.getDecodedJWT((String)accessToken);
        JSONObject jwtObject = new JSONObject(jwtString);
        log.info((Object)("Decoded JWT token: " + jwtString));
        JSONObject tierInfo = (JSONObject)((JSONObject)jwtObject.get("tierInfo")).get(this.subPolicyName);
        Assert.assertEquals((boolean)tierInfo.has("tierQuotaType"), (boolean)true, (String)"tierQuotaType property does not exist in the JWT");
        Assert.assertEquals((Object)tierInfo.get("tierQuotaType"), (Object)"bandwidthVolume", (String)"tierQuotaType property does not match 'bandwidthVolume' in the JWT");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.gatewayUrl, requestHeaders, (String)this.body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by bandwidth condition in subscription tier");
    }

    @Test(groups={"wso2.am"}, description="", dependsOnMethods={"testSubscriptionLevelThrottling", "testApplicationLevelThrottling"})
    public void testAPILevelThrottling() throws Exception {
        HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        Gson gson = new Gson();
        APIDTO apidto = (APIDTO)gson.fromJson(api.getData(), APIDTO.class);
        apidto.setApiThrottlingPolicy(this.apiPolicyName);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiId);
        Assert.assertEquals((String)updatedAPI.getApiThrottlingPolicy(), (String)this.apiPolicyName, (String)"API tier not updated.");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("NormalAPP", "Unlimited", "", "this-is-test");
        this.app3Id = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Unlimited");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Unlimited"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("content-type", "application/json");
        boolean isThrottled = false;
        for (int i = 0; i < 15; ++i) {
            HttpResponse response = HTTPSClientUtils.doPost((String)this.gatewayUrl, requestHeaders, (String)this.body);
            log.info((Object)("==============Response " + response.getResponseCode()));
            if (response.getResponseCode() == 429) {
                isThrottled = true;
                break;
            }
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)isThrottled, (String)"Request not throttled by bandwidth condition in api tier");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.app1Id);
        this.restAPIStore.deleteApplication(this.app2Id);
        this.restAPIStore.deleteApplication(this.app3Id);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.adminDashboardRestClient.deleteAPIPolicy(this.apiPolicyName);
        this.adminDashboardRestClient.deleteApplicationPolicy(this.appPolicyName);
        this.adminDashboardRestClient.deleteSubscriptionPolicy(this.subPolicyName);
    }
}

