/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TokenAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(TokenAPITestCase.class);
    private String apiId;
    private String apiIdForOauth;
    private String tokenTestApiAppId;
    private String tokenTestAppId;
    private String oauthTokenTestApiId;

    @Factory(dataProvider="userModeDataProvider")
    public TokenAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Token API Test other")
    public void testTokenAPITestCase() throws Exception {
        String APIName = "TokenTestAPI";
        String APIContext = "tokenTestAPI";
        String tags = "youtube, token, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Publish");
        String gatewayUrl = this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/customers/123");
        ApplicationDTO applicationDTO = this.restAPIStore.addApplication("TokenTestAPI-Application", "Unlimited", "", "this-is-test");
        this.tokenTestApiAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiId, applicationDTO.getApplicationId(), "Gold");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Gold"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        String sandboxAccessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        requestHeadersSandBox.put("Authorization", "Bearer " + sandboxAccessToken);
        requestHeadersSandBox.put("accept", "text/xml");
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        Assert.assertEquals((int)youTubeResponseSandBox.getResponseCode(), (int)200, (String)"Response code mismatched");
        ApplicationKeyDTO productionApplicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = productionApplicationKeyDTO.getToken().getAccessToken();
        String consumerKey = productionApplicationKeyDTO.getConsumerKey();
        String consumerSecret = productionApplicationKeyDTO.getConsumerSecret();
        Thread.sleep(2000L);
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.getGatewayURLNhttp() + "token");
        HttpResponse httpAccessTokenGenerationResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpAccessTokenGenerationResponse.getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        HttpResponse youTubeResponseWithApplicationToken = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponseWithApplicationToken.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<Customer>"), (String)"Response data mismatched");
        HttpResponse youTubeResponseWithApplicationTokenHttps = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        log.info((Object)("Response " + youTubeResponseWithApplicationTokenHttps));
        Assert.assertEquals((int)youTubeResponseWithApplicationTokenHttps.getResponseCode(), (int)200, (String)"Response code mismatched");
        HttpResponse errorResponse = null;
        errorResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        log.info((Object)("Error response " + errorResponse));
        this.restAPIPublisher.revokeAccessToken(accessToken, consumerKey, providerName);
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer this-is-incorrect-token");
        requestHeaders.put("accept", "text/xml");
        errorResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
        try {
            errorResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/most_popular"), requestHeaders);
            log.info((Object)("Error Response " + errorResponse));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
    }

    @Test(groups={"wso2.am"}, description="Token equality test", dependsOnMethods={"testTokenAPITestCase"})
    public void testTokenEqualityBeforeExpiration() throws Exception {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("TokenTestApp", "Unlimited", "", "this-is-test", "OAUTH");
        this.tokenTestAppId = applicationDTO.getApplicationId();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=default";
        HttpResponse firstResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject firstAccessTokenGenerationResponse = new JSONObject(firstResponse.getData());
        String firstAccessToken = firstAccessTokenGenerationResponse.getString("access_token");
        HttpResponse secondResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject secondAccessTokenGenerationResponse = new JSONObject(secondResponse.getData());
        String secondAccessToken = secondAccessTokenGenerationResponse.getString("access_token");
        Assert.assertEquals((String)firstAccessToken, (String)secondAccessToken, (String)"Token mismatch while generating access token twice.");
    }

    @Test(groups={"wso2.am"}, description="Oauth Token API Test other", dependsOnMethods={"testTokenEqualityBeforeExpiration"})
    public void testOauthTokenAPITestCase() throws Exception {
        String APIName = "oauthTokenTestAPI";
        String APIContext = "oauthTokenTestAPI";
        String tags = "Oauth, token";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiIdForOauth = serviceResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiIdForOauth, "Publish");
        String gatewayUrl = this.getAPIInvocationURLHttp("oauthTokenTestAPI/1.0.0/customers/123");
        Thread.sleep(3000L);
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType("oauthTokenTestAPI-Application", "Unlimited", "", "this-is-test", "OAUTH");
        this.oauthTokenTestApiId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.apiIdForOauth, applicationDTO.getApplicationId(), "Gold");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Gold"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        String sandboxAccessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        requestHeadersSandBox.put("Authorization", "Bearer " + sandboxAccessToken);
        requestHeadersSandBox.put("accept", "text/xml");
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        Assert.assertEquals((int)youTubeResponseSandBox.getResponseCode(), (int)200, (String)"Response code mismatched");
        ApplicationKeyDTO productionApplicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = productionApplicationKeyDTO.getToken().getAccessToken();
        String consumerKey = productionApplicationKeyDTO.getConsumerKey();
        String consumerSecret = productionApplicationKeyDTO.getConsumerSecret();
        Thread.sleep(2000L);
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.getGatewayURLNhttp() + "token");
        HttpResponse httpAccessTokenGenerationResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpAccessTokenGenerationResponse.getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.tokenTestApiAppId);
        this.restAPIStore.deleteApplication(this.tokenTestAppId);
        this.restAPIStore.deleteApplication(this.oauthTokenTestApiId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.apiIdForOauth);
    }
}

