/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.admin;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.ApplicationListDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class OAuthApplicationOwnerUpdateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(OAuthApplicationOwnerUpdateTestCase.class);
    private UserManagementClient userManagementClient1 = null;
    private static final String USER_JOHN = "john1";
    private static final String USER_JOHN_PWD = "john1@";
    private static final String JOHN_APP = "johnApp";
    private static final String USER_MARY = "mary1";
    private static final String USER_MARY_PWD = "mary1@";
    private static final String MARY_APP = "maryApp";
    private static final String TENANT_ADMIN = "admin";
    private static final String TENANT_ADMIN_PWD = "admin1@";
    private static final String TENANT_USER1 = "user1";
    private static final String TENANT_USER1_PWD = "user1@";
    private static final String TENANT_USER1_APP = "user1App";
    private static final String TENANT_USER2 = "user2";
    private static final String TENANT_USER2_PWD = "user2@";
    private static final String TENANT_USER2_APP = "user2App";
    private static final String TENANT_USER3 = "user3";
    private static final String TENANT_USER3_PWD = "user3@";
    private static final String TENANT_USER3_APP = "user3App";
    private static final String TENANT_DOMAIN = "tenant.com";
    private static final String TENANT_ADMIN_WITH_DOMAIN = "admin@tenant.com";
    private static final String TENANT_ADMIN_APP = "tenantAdminApp";
    private static final String TENANT_USER1_WITH_DOMAIN = "user1@tenant.com";
    private static final String TENANT_USER2_WITH_DOMAIN = "user2@tenant.com";
    private static final String TENANT_USER3_WITH_DOMAIN = "user3@tenant.com";
    private static final String TENANT_USER4_WITH_DOMAIN = "user4@tenant.com";
    private String[] subscriberRole = new String[]{"Internal/subscriber"};
    private RestAPIStoreImpl restAPIStoreClient1;
    private RestAPIStoreImpl restAPIStoreClient2;
    private RestAPIStoreImpl restAPIStoreClient3;
    private RestAPIStoreImpl restAPIStoreClient4;
    private RestAPIStoreImpl restAPIStoreClient5;
    private RestAPIStoreImpl restAPIStoreClient6;
    private RestAPIAdminImpl restAPIAdminClient;
    private String appIdOfJohnApp;
    private String appIdOfMaryApp;
    private String appIdOfJohnMaryApp;
    private String appIdOfTenantAdminApp;
    private String appIdOfTenantUser1App;
    private String appIdOfTenantUser2App;
    private String appIdOfTenantUser3App;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient.addUser(USER_JOHN, USER_JOHN_PWD, this.subscriberRole, USER_JOHN);
        this.userManagementClient.addUser(USER_MARY, USER_MARY_PWD, this.subscriberRole, USER_MARY);
        this.tenantManagementServiceClient.addTenant(TENANT_DOMAIN, TENANT_ADMIN_PWD, TENANT_ADMIN, "demo");
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), TENANT_ADMIN_WITH_DOMAIN, TENANT_ADMIN_PWD);
        this.userManagementClient1.addUser(TENANT_USER1, TENANT_USER1_PWD, this.subscriberRole, TENANT_USER1);
        this.userManagementClient1.addUser(TENANT_USER2, TENANT_USER2_PWD, this.subscriberRole, TENANT_USER2);
        this.userManagementClient1.addUser(TENANT_USER3, TENANT_USER3_PWD, this.subscriberRole, TENANT_USER3);
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.restAPIStoreClient1 = new RestAPIStoreImpl(USER_JOHN, USER_JOHN_PWD, "carbon.super", this.storeURLHttps);
        ApplicationDTO appOfJohnDTO = this.restAPIStoreClient1.addApplication(JOHN_APP, "Unlimited", "", "App of user John");
        this.appIdOfJohnApp = appOfJohnDTO.getApplicationId();
        this.waitForKeyManagerDeployment(TENANT_DOMAIN, "Default");
        this.restAPIStoreClient1.generateKeys(this.appIdOfJohnApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient2 = new RestAPIStoreImpl(USER_MARY, USER_MARY_PWD, "carbon.super", this.storeURLHttps);
        ApplicationDTO appOfMaryDTO = this.restAPIStoreClient2.addApplication(MARY_APP, "Unlimited", "", "App of user Mary");
        this.appIdOfMaryApp = appOfMaryDTO.getApplicationId();
        this.restAPIStoreClient2.generateKeys(this.appIdOfMaryApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        ApplicationDTO appOfJohnMaryDTO = this.restAPIStoreClient2.addApplication(JOHN_APP, "Unlimited", "", "App of user Mary");
        this.appIdOfJohnMaryApp = appOfJohnMaryDTO.getApplicationId();
        this.restAPIStoreClient2.generateKeys(this.appIdOfJohnMaryApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient3 = new RestAPIStoreImpl(TENANT_ADMIN, TENANT_ADMIN_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantAdminDTO = this.restAPIStoreClient3.addApplication(TENANT_ADMIN_APP, "10PerMin", "", "App of tenant admin");
        this.appIdOfTenantAdminApp = appOfTenantAdminDTO.getApplicationId();
        this.restAPIStoreClient3.generateKeys(this.appIdOfTenantAdminApp, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient4 = new RestAPIStoreImpl(TENANT_USER1, TENANT_USER1_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantUser1DTO = this.restAPIStoreClient4.addApplication(TENANT_USER1_APP, "10PerMin", "", "App of tenant user 1");
        this.appIdOfTenantUser1App = appOfTenantUser1DTO.getApplicationId();
        this.restAPIStoreClient4.generateKeys(this.appIdOfTenantUser1App, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient5 = new RestAPIStoreImpl(TENANT_USER2, TENANT_USER2_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantUser2DTO = this.restAPIStoreClient5.addApplication(TENANT_USER2_APP, "10PerMin", "", "App of tenant user 2");
        this.appIdOfTenantUser2App = appOfTenantUser2DTO.getApplicationId();
        this.restAPIStoreClient5.generateKeys(this.appIdOfTenantUser2App, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStoreClient6 = new RestAPIStoreImpl(TENANT_USER3, TENANT_USER3_PWD, TENANT_DOMAIN, this.storeURLHttps);
        ApplicationDTO appOfTenantUser3DTO = this.restAPIStoreClient6.addApplication(TENANT_USER3_APP, "10PerMin", "", "App of tenant user 3");
        this.appIdOfTenantUser3App = appOfTenantUser3DTO.getApplicationId();
        this.restAPIStoreClient6.generateKeys(this.appIdOfTenantUser3App, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
    }

    @Test(groups={"wso2.am"}, description="Check whether the new owner is a valid subscriber")
    public void checkSubscriberValidity() {
        this.restAPIAdminClient = new RestAPIAdminImpl(TENANT_ADMIN, TENANT_ADMIN_PWD, TENANT_DOMAIN, this.publisherURLHttps);
        try {
            this.updateOwner(this.appIdOfTenantUser3App, TENANT_USER4_WITH_DOMAIN, TENANT_DOMAIN);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @Test(groups={"wso2.am"}, description="Update application ownership to a user from another tenant domain")
    public void updateApplicationOwnerAcrossTenant() {
        this.restAPIAdminClient = new RestAPIAdminImpl(TENANT_ADMIN, TENANT_ADMIN_PWD, TENANT_DOMAIN, this.publisherURLHttps);
        try {
            this.updateOwner(this.appIdOfTenantUser1App, USER_MARY, TENANT_DOMAIN);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @Test(groups={"wso2.am"}, description="Check whether the new owner already has an application with that name")
    public void checkApplicationExist() {
        this.restAPIAdminClient = new RestAPIAdminImpl(this.user.getUserName(), this.user.getPassword(), "carbon.super", this.publisherURLHttps);
        try {
            this.updateOwner(this.appIdOfJohnMaryApp, USER_JOHN, this.user.getUserDomain());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)500);
        }
    }

    @Test(groups={"wso2.am"}, description="Update application ownership to another user within the same domain")
    public void updateApplicationOwner() throws Exception {
        this.restAPIAdminClient = new RestAPIAdminImpl(this.user.getUserName(), this.user.getPassword(), "carbon.super", this.publisherURLHttps);
        this.updateOwner(this.appIdOfMaryApp, USER_JOHN, this.user.getUserDomain());
        this.restAPIAdminClient = new RestAPIAdminImpl(TENANT_ADMIN, TENANT_ADMIN_PWD, TENANT_DOMAIN, this.publisherURLHttps);
        this.updateOwner(this.appIdOfTenantUser2App, TENANT_USER1_WITH_DOMAIN, TENANT_DOMAIN);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStoreClient1.deleteApplication(this.appIdOfJohnApp);
        this.restAPIStoreClient2.deleteApplication(this.appIdOfMaryApp);
        this.restAPIStoreClient3.deleteApplication(this.appIdOfTenantAdminApp);
        this.restAPIStoreClient4.deleteApplication(this.appIdOfTenantUser1App);
        this.restAPIStoreClient5.deleteApplication(this.appIdOfTenantUser2App);
        this.restAPIStoreClient6.deleteApplication(this.appIdOfTenantUser3App);
        if (this.userManagementClient != null) {
            this.userManagementClient.deleteUser(USER_JOHN);
            this.userManagementClient.deleteUser(USER_MARY);
        }
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser(TENANT_USER1);
            this.userManagementClient1.deleteUser(TENANT_USER2);
            this.userManagementClient1.deleteUser(TENANT_USER3);
        }
        this.tenantManagementServiceClient.deleteTenant(TENANT_DOMAIN);
    }

    private void updateOwner(String applicationId, String newOwner, String appTenantDomain) throws ApiException {
        ApiResponse changeOwnerResponse = this.restAPIAdminClient.changeApplicationOwner(newOwner, applicationId);
        Assert.assertEquals((int)changeOwnerResponse.getStatusCode(), (int)200);
        ApiResponse getApplicationsResponse = this.restAPIAdminClient.getApplications(newOwner, null, null, appTenantDomain);
        Assert.assertEquals((int)getApplicationsResponse.getStatusCode(), (int)200);
        ApplicationListDTO applicationList = (ApplicationListDTO)getApplicationsResponse.getData();
        List applicationInfoList = applicationList.getList();
        for (ApplicationInfoDTO applicationInfo : applicationInfoList) {
            if (!applicationInfo.getApplicationId().equals(applicationId)) continue;
            String owner = applicationInfo.getOwner();
            Assert.assertEquals((String)owner, (String)newOwner);
            break;
        }
    }
}

