/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.TagDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APITagVisibilityByRoleTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APITagVisibilityByRoleTestCase.class);
    private String NAME_PUBLIC_API = "APITagVisibilityPublicAPI";
    private String CONTEXT_PUBLIC_API = "contextPublicAPI";
    private String NAME_RESTRICTED_API = "APITagVisibilityRestrictedAPI";
    private String CONTEXT_RESTRICTED_API = "contextRestrictedAPI";
    private String TAGS_PUBLIC_API = "APITagVisibilityPublicTag";
    private String TAGS_RESTRICTED_API = "APITagVisibilityRestrictedTag";
    private String DESCRIPTION = "This is test API create by APIM APITagVisibilityByRoleTestCase";
    private String API_VERSION_1_0_0 = "1.0.0";
    private String ALLOWED_USER = "AllowedUser";
    private String ALLOWED_USER_PASS = "password@123";
    private String ROLE = "APITagVisibleRole";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String[] PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
    private UserManagementClient userManagementClient;
    private String endpointUrl;
    private String providerName;
    private String publicApiId;
    private String restrictedApiId;
    private RestAPIStoreImpl apiStoreClientAllowedUser;
    private RestAPIStoreImpl anonymousRestAPIImpl;

    @Factory(dataProvider="userModeDataProvider")
    public APITagVisibilityByRoleTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.ROLE = "secondary/" + this.ROLE;
            this.ALLOWED_USER = "secondary/" + this.ALLOWED_USER;
        }
        this.userManagementClient.addRole(this.ROLE, null, this.PERMISSIONS);
        this.userManagementClient.addUser(this.ALLOWED_USER, this.ALLOWED_USER_PASS, new String[]{this.ROLE}, null);
        this.apiStoreClientAllowedUser = new RestAPIStoreImpl(this.ALLOWED_USER, this.ALLOWED_USER_PASS, this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        this.anonymousRestAPIImpl = this.getRestAPIStoreForAnonymousUser(this.keyManagerContext.getContextTenant().getDomain());
    }

    @Test(groups={"wso2.am"}, description="Create and publish two apis with public and role based visibility")
    public void testAPICreationWithVisibility() throws Exception {
        APICreationRequestBean apiCreationReqBeanPublicAPI = new APICreationRequestBean(this.NAME_PUBLIC_API, this.CONTEXT_PUBLIC_API, this.API_VERSION_1_0_0, this.providerName, new URL(this.endpointUrl));
        apiCreationReqBeanPublicAPI.setTags(this.TAGS_PUBLIC_API);
        apiCreationReqBeanPublicAPI.setDescription(this.DESCRIPTION);
        apiCreationReqBeanPublicAPI.setVersion(this.API_VERSION_1_0_0);
        apiCreationReqBeanPublicAPI.setProvider(this.providerName);
        APIDTO apiDtoPublicAPI = this.restAPIPublisher.addAPI(apiCreationReqBeanPublicAPI);
        this.publicApiId = apiDtoPublicAPI.getId();
        this.publishAPI(this.publicApiId, this.restAPIPublisher, false);
        this.waitForAPIDeployment();
        APICreationRequestBean apiCreationRequestBeanRestrictedAPI = new APICreationRequestBean(this.NAME_RESTRICTED_API, this.CONTEXT_RESTRICTED_API, this.API_VERSION_1_0_0, this.providerName, new URL(this.endpointUrl));
        apiCreationRequestBeanRestrictedAPI.setTags(this.TAGS_RESTRICTED_API);
        apiCreationRequestBeanRestrictedAPI.setDescription(this.DESCRIPTION);
        apiCreationRequestBeanRestrictedAPI.setVisibility(APIDTO.VisibilityEnum.RESTRICTED.getValue());
        apiCreationRequestBeanRestrictedAPI.setRoles(this.ROLE);
        APIDTO apiDtoRestrictedAPI = this.restAPIPublisher.addAPI(apiCreationRequestBeanRestrictedAPI);
        this.restrictedApiId = apiDtoRestrictedAPI.getId();
        this.publishAPI(this.restrictedApiId, this.restAPIPublisher, false);
        this.waitForAPIDeployment();
    }

    @Test(groups={"wso2.am"}, description="Test the API tag visibility as a anonymous user", dependsOnMethods={"testAPICreationWithVisibility"})
    public void testAPITagVisibilityAnonymousUser() throws Exception {
        List tagDto = this.anonymousRestAPIImpl.getAllTags().getList();
        ArrayList tagList = new ArrayList();
        tagDto.forEach(tempDto -> tagList.add(tempDto.getValue()));
        Assert.assertTrue((boolean)tagList.contains(this.TAGS_PUBLIC_API), (String)"Public visibility tag is not available for anonymous user");
        Assert.assertFalse((boolean)tagList.contains(this.TAGS_RESTRICTED_API), (String)"Restricted visibility tag is available for anonymous user");
    }

    @Test(groups={"wso2.am"}, description="Test the API tag visibility as a authorised user", dependsOnMethods={"testAPITagVisibilityAnonymousUser"})
    public void testAPITagVisibilityAuthorisedUser() throws Exception {
        List tagDtoList = this.apiStoreClientAllowedUser.getAllTags().getList();
        ArrayList<String> tagList = new ArrayList<String>();
        for (TagDTO tempTagDTO : tagDtoList) {
            tagList.add(tempTagDTO.getValue());
        }
        Assert.assertTrue((boolean)tagList.contains(this.TAGS_PUBLIC_API), (String)"Public visibility tag is not available for authorised user");
        int retry = 10;
        if (!tagList.contains(this.TAGS_RESTRICTED_API)) {
            Thread.sleep(3000L);
            for (int i = 0; i < retry; ++i) {
                tagDtoList = this.apiStoreClientAllowedUser.getAllTags().getList();
                tagList = new ArrayList();
                for (TagDTO tempTagDTO : tagDtoList) {
                    tagList.add(tempTagDTO.getValue());
                }
                if (tagList.contains(this.TAGS_RESTRICTED_API)) break;
                Thread.sleep(3000L);
                this.log.info((Object)"Waiting for the API Tags");
            }
        }
        Assert.assertTrue((boolean)tagList.contains(this.TAGS_RESTRICTED_API), (String)"Restricted visibility tag is not available for authorised user");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPIByID(this.publicApiId);
        this.restAPIPublisher.deleteAPIByID(this.restrictedApiId);
        this.userManagementClient.deleteRole(this.ROLE);
        this.userManagementClient.deleteUser(this.ALLOWED_USER);
    }
}

