/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIVisibilityByDomainTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "APIVisibilityByDomainTest";
    private final String API_CONTEXT = "APIVisibilityByDomain";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String EMAIL_USER_KEY = "emailUser";
    private final String EMAIL_USER2_KEY = "emailUser2";
    private final String EMAIL_USER3_KEY = "emailUser3";
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String USER_KEY_USER2 = "userKey1";
    private final String CARBON_SUPER_TENANT2_KEY = "userKey2";
    private final String OTHER_DOMAIN_TENANT_USER_KEY = "user1";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String AT = "@";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private String otherDomain;
    private RestAPIPublisherImpl restAPIPublisherCarbonSuperAdmin;
    private RestAPIStoreImpl restAPIStoreCarbonSuperAdmin;
    private RestAPIPublisherImpl restAPIPublisherCarbonSuperUser1;
    private RestAPIStoreImpl restAPIStoreCarbonSuperUser1;
    private RestAPIPublisherImpl restAPIPublisherCarbonSuperUser2;
    private RestAPIStoreImpl restAPIStoreCarbonSuperUser2;
    private RestAPIPublisherImpl restAPIPublisherOtherDomainUser;
    private RestAPIStoreImpl restAPIStoreOtherDomainUser;
    private RestAPIPublisherImpl restAPIPublisherOtherDomainAdmin;
    private RestAPIStoreImpl restAPIStoreOtherDomainAdmin;
    private String apiID;
    private String apiCreatorStoreDomain;
    private User user2;
    private User user3;
    private User otherDomainUser2;

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_EMAIL_USER}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public APIVisibilityByDomainTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        String username3;
        String username2;
        super.init(this.userMode);
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.storeURLHttp = this.getStoreURLHttp();
        this.restAPIPublisherCarbonSuperAdmin = new RestAPIPublisherImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.publisherURLHttps);
        this.restAPIStoreCarbonSuperAdmin = new RestAPIStoreImpl(this.user.getUserNameWithoutDomain(), this.user.getPassword(), this.user.getUserDomain(), this.storeURLHttps);
        this.apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.user2 = this.publisherContext.getContextTenant().getTenantUser("userKey1");
            this.user3 = this.publisherContext.getContextTenant().getTenantUser("userKey2");
            username2 = this.user2.getUserNameWithoutDomain();
            username3 = this.user3.getUserNameWithoutDomain();
            this.providerName = this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName();
        } else {
            this.user2 = this.publisherContext.getContextTenant().getTenantUser("emailUser2");
            this.user3 = this.publisherContext.getContextTenant().getTenantUser("emailUser3");
            username2 = this.user2.getUserName();
            username3 = this.user3.getUserName();
            this.providerName = this.publisherContext.getContextTenant().getTenantUser("emailUser2").getUserName() + "@" + this.apiCreatorStoreDomain;
        }
        this.restAPIPublisherCarbonSuperUser1 = new RestAPIPublisherImpl(username2, this.user2.getPassword(), "carbon.super", this.publisherURLHttps);
        this.restAPIStoreCarbonSuperUser1 = new RestAPIStoreImpl(username2, this.user2.getPassword(), "carbon.super", this.storeURLHttps);
        this.restAPIPublisherCarbonSuperUser2 = new RestAPIPublisherImpl(username3, this.user3.getPassword(), "carbon.super", this.publisherURLHttps);
        this.restAPIStoreCarbonSuperUser2 = new RestAPIStoreImpl(username3, this.user3.getPassword(), "carbon.super", this.storeURLHttps);
        if (TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode)) {
            this.init("wso2.com", "admin");
            this.otherDomainUser2 = this.storeContext.getContextTenant().getTenantUser("user1");
        } else {
            this.init("wso2.com", "emailUser");
            this.otherDomainUser2 = this.storeContext.getContextTenant().getTenantUser("emailUser2");
        }
        this.otherDomain = this.storeContext.getContextTenant().getDomain();
        this.restAPIPublisherOtherDomainUser = new RestAPIPublisherImpl(this.otherDomainUser2.getUserNameWithoutDomain(), this.otherDomainUser2.getPassword(), this.otherDomain, this.publisherURLHttps);
        this.restAPIStoreOtherDomainUser = new RestAPIStoreImpl(this.otherDomainUser2.getUserNameWithoutDomain(), this.otherDomainUser2.getPassword(), this.otherDomain, this.storeURLHttps);
        this.restAPIPublisherOtherDomainAdmin = new RestAPIPublisherImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.otherDomain, this.publisherURLHttps);
        this.restAPIStoreOtherDomainAdmin = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.otherDomain, this.storeURLHttps);
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for API creator ")
    public void testVisibilityForCreatorInPublisher() throws Exception {
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByDomainTest", "1.0.0");
        APIRequest apiCreationRequest = new APIRequest("APIVisibilityByDomainTest", "APIVisibilityByDomain", new URL(this.apiEndPointUrl));
        apiCreationRequest.setProvider(this.providerName);
        apiCreationRequest.setVersion("1.0.0");
        apiCreationRequest.setTags("testTag1, testTag2, testTag3");
        apiCreationRequest.setDescription("This is test API create by API manager integration test");
        apiCreationRequest.setVisibility("PRIVATE");
        APIDTO apiAddResponse = this.restAPIPublisherCarbonSuperUser1.addAPI(apiCreationRequest, "v3");
        this.apiID = apiAddResponse.getId();
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByDomainTest", "1.0.0");
        HttpResponse apiPublishResponse = this.restAPIPublisherCarbonSuperUser1.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.PUBLISH.getAction(), null);
        this.waitForAPIDeployment();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllApisResponse = this.restAPIPublisherCarbonSuperUser1.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllApisResponse), (String)"API is not visible to creator in APi Publisher. When Visibility is private. ");
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for API creator", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForCreatorInStore() throws APIManagerIntegrationTestException {
        APIListDTO apiListDTO = this.restAPIStoreCarbonSuperUser1.getAllPublishedAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is not visible to creator in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in same domain ", dependsOnMethods={"testVisibilityForCreatorInStore"})
    public void testVisibilityForAdminInSameDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllApisResponse = this.restAPIPublisherCarbonSuperAdmin.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllApisResponse), (String)("API is not visible to admin in same domain in API Publisher. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in same domain ", dependsOnMethods={"testVisibilityForAdminInSameDomainInPublisher"})
    public void testVisibilityForAdminInSameDomainInStore() throws APIManagerIntegrationTestException {
        APIListDTO apiListDTO = this.restAPIStoreCarbonSuperAdmin.getAllPublishedAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is not visible to admin in same domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in same domain", dependsOnMethods={"testVisibilityForAdminInSameDomainInStore"})
    public void testVisibilityForAnotherUserInSameDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllApisResponse = this.restAPIPublisherCarbonSuperUser2.getAllAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllApisResponse), (String)("API is not visible to another user in same domain in API Publisher. When Visibility is private." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInPublisher"})
    public void testVisibilityForAnotherUserInSameDomainInStore() throws APIManagerIntegrationTestException {
        APIListDTO apiListDTO = this.restAPIStoreCarbonSuperUser2.getAllPublishedAPIs();
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is not visible to another user in same domain in API Store. When Visibility is private." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInStore"})
    public void testVisibilityForAnotherUserInOtherDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllApisResponse = this.restAPIPublisherOtherDomainUser.getAllAPIs();
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllApisResponse), (String)("API is  visible to another user in other domain in API Publisher. When Visibility is private." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInPublisher"})
    public void testVisibilityForAnotherUserInOtherDomainInStore() throws APIManagerIntegrationTestException {
        APIListDTO apiListDTO = this.restAPIStoreOtherDomainUser.getAllPublishedAPIs();
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is  visible to another user in other domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInStore"})
    public void testVisibilityForAdminInOtherDomainInPublisher() throws APIManagerIntegrationTestException, ApiException {
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO getAllApisResponse = this.restAPIPublisherOtherDomainAdmin.getAllAPIs();
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO)getAllApisResponse), (String)("API is  visible to admin in other domain in API Publisher. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in other domain", dependsOnMethods={"testVisibilityForAdminInOtherDomainInPublisher"})
    public void testVisibilityForAdminInOtherDomainInStore() throws APIManagerIntegrationTestException {
        APIListDTO apiListDTO = this.restAPIStoreOtherDomainAdmin.getAllPublishedAPIs();
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is  visible to admin in other domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in Same domainStore for anonymous user", dependsOnMethods={"testVisibilityForAdminInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInSameDomainInStore() throws Exception {
        APIListDTO apiListDTO = this.restAPIStoreCarbonSuperAdmin.getAPIListFromStoreAsAnonymousUser("carbon.super");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is  visible to anonymous in same domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in other domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnonymousUserInSameDomainInStore"})
    public void testVisibilityForAnonymousUserInOtherDomainInStore() throws Exception {
        APIListDTO apiListDTO = this.restAPIStoreOtherDomainAdmin.getAPIListFromStoreAsAnonymousUser(this.otherDomain);
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailableInStore((APIIdentifier)this.apiIdentifier, (APIListDTO)apiListDTO), (String)("API is visible to anonymous user in other domain API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.deleteAPI(this.apiID, this.apiIdentifier, this.restAPIPublisherCarbonSuperUser1);
    }
}

