/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AddEditRemoveRESTResourceTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String INVOKABLE_API_CONTEXT = "1.0.0/api";
    private final String RESPONSE_GET = "<id>123</id><name>John</name></Customer>";
    private final String RESPONSE_POST = "Tom";
    private final String API_GET_ENDPOINT_METHOD = "/customers/123";
    private final String API_POST_ENDPOINT_METHOD = "/customers/name/";
    private final String INVALID_URL = "/invalid";
    private final String INVALID_RESOURCE_INVOCATION = "No matching resource found for given API Request";
    private String apiEndPointUrl;
    private String providerName;
    private String postEndPointURL;
    private HashMap<String, String> requestHeadersGet;
    private HashMap<String, String> requestHeadersPost;
    private ITestContext ctx;

    @BeforeClass(alwaysRun=true)
    public void initialize(ITestContext ctx) throws APIManagerIntegrationTestException, XPathExpressionException {
        super.init();
        this.postEndPointURL = this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/name/";
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/xml");
        this.requestHeadersPost = new HashMap();
        this.requestHeadersPost.put("accept", "text/plain");
        this.requestHeadersPost.put("Content-Type", "text/plain");
        this.ctx = ctx;
    }

    @Test(groups={"webapp"}, description="Test the invocation of GET resource")
    public void testInvokeGETResource(ITestContext ctx) throws Exception {
        String accessToken = (String)ctx.getAttribute("accessToken");
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersPost.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertTrue((boolean)httpResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponse.getData() + "\""));
    }

    @Test(groups={"webapp"}, description="Test the invocation of POST resource, before adding a POSt resource", dependsOnMethods={"testInvokeGETResource"})
    public void testInvokePOSTResourceBeforeAddingPOSTResource() throws APIManagerIntegrationTestException, MalformedURLException {
        String exceptionMessage = "";
        try {
            HttpRequestUtil.doPost((URL)new URL(this.postEndPointURL), (String)"id=25", this.requestHeadersPost);
        }
        catch (AutomationFrameworkException e) {
            exceptionMessage = e.getMessage();
        }
        finally {
            Assert.assertTrue((boolean)exceptionMessage.contains("Server returned HTTP response code: 405"), (String)("Not Return IOException with 405 when accessing a POST resource which is not define yet. " + exceptionMessage));
            Assert.assertTrue((boolean)exceptionMessage.contains("1.0.0/api"), (String)("API Context is not in error message " + exceptionMessage));
        }
    }

    @Test(groups={"webapp"}, description="Test the invocation of POST and GET resource, after adding a POST resource", dependsOnMethods={"testInvokePOSTResourceBeforeAddingPOSTResource"})
    public void testInvokePOSTAndGETResourceAfterAddingPOSTResource() throws Exception {
        String apiId = (String)this.ctx.getAttribute("apiId");
        HttpResponse response = this.restAPIPublisher.getAPI(apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        List operation = apidto.getOperations();
        APIOperationsDTO apiOperationsDTO2 = new APIOperationsDTO();
        apiOperationsDTO2.setVerb("POST");
        apiOperationsDTO2.setTarget("/customers/name/");
        apiOperationsDTO2.setAuthType("Application & Application User");
        apiOperationsDTO2.setThrottlingPolicy("Unlimited");
        operation.add(apiOperationsDTO2);
        APIDTO updateReponse = this.restAPIPublisher.updateAPI(apidto, apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateReponse.getId()), (String)"Update APi with new Resource information fail");
        this.waitForAPIDeployment();
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request after update the api with  both GET and POST resource");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request after update the api with  both GET and POST resource. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        HttpResponse httpResponsePOST = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/name/"), (String)"id=25", this.requestHeadersPost);
        Assert.assertEquals((int)httpResponsePOST.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation of  POST resource fail after update the api with  both GET and POST resource");
        Assert.assertTrue((boolean)httpResponsePOST.getData().contains("Tom"), (String)("Invocation of  POST resource fail after update the api with both GET and POST resource. Expected value :\"Tom\" not contains in response data:\"" + httpResponsePOST.getData() + "\""));
    }

    @Test(groups={"webapp"}, description="Test the invocation of POST and GET resource, after adding a URL pattern", dependsOnMethods={"testInvokePOSTAndGETResourceAfterAddingPOSTResource"})
    public void testInvokePOSTAndGetResourceAfterAddingURLPattern() throws Exception {
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request after update the api with  URLPattern");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request after update the api with  URLPattern. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
        HttpResponse httpResponseGetInvalidUrl = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/123" + "/invalid"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGetInvalidUrl.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Invocation is not forbidden when try to invoke GET resource  via invalid url pattern");
        Assert.assertTrue((boolean)httpResponseGetInvalidUrl.getData().contains("No matching resource found for given API Request"), (String)("Invocation is not forbidden when try to invoke GET resource  via invalid url pattern. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGetInvalidUrl.getData() + "\""));
        HttpResponse httpResponsePOST = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp("1.0.0/api") + "/customers/name/"), (String)"id=25", this.requestHeadersPost);
        Assert.assertEquals((int)httpResponsePOST.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation of  POST resource fail after update the api with  URLPattern");
        Assert.assertTrue((boolean)httpResponsePOST.getData().contains("Tom"), (String)("Invocation of  POST resource fail after update the api with  URLPattern. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponsePOST.getData() + "\""));
    }
}

