/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeApplicationTierAndTestInvokingTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeApplicationTierAndTestInvokingTest";
    private final String API_CONTEXT = "ChangeApplicationTierAndTestInvoking";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeApplicationTierAndTestInvokingTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private String applicationNameGold;
    private String applicationNameSilver;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private APICreationRequestBean apiCreationRequestBean;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("ChangeApplicationTierAndTestInvokingTest", "ChangeApplicationTierAndTestInvoking", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeApplicationTierAndTestInvokingTest", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="test  invocation of  api under  API tier Gold  and Application Tire Silver.")
    public void testInvokingWithAPIGoldTierApplicationSilver() throws Exception {
        long currentTime;
        this.applicationNameSilver = "ChangeApplicationTierAndTestInvokingTestCaseSilver";
        this.apiStoreClientUser1.addApplication(this.applicationNameSilver, "Silver", "", "");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "ChangeApplicationTierAndTestInvokingTest", "1.0.0");
        apiIdentifier.setTier("Gold");
        this.createPublishAndSubscribeToAPI(apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, this.applicationNameSilver);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeApplicationTierAndTestInvokingTest", "1.0.0", "\"isApiExists\":true");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, this.applicationNameSilver).getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 5; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Silver Application level tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API and Silver Application level tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier"));
    }

    @Test(groups={"wso2.am"}, description="test  invocation of  api under API tier Gold  and Application Tire Gold..", dependsOnMethods={"testInvokingWithAPIGoldTierApplicationSilver"})
    public void testInvokingWithAPIGoldTierApplicationGold() throws Exception, InterruptedException, IOException {
        long currentTime;
        this.applicationNameGold = "ChangeApplicationTierAndTestInvokingTestCaseGold";
        this.apiStoreClientUser1.updateApplication(this.applicationNameSilver, this.applicationNameGold, "", "", "Gold");
        Thread.sleep(65000L);
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 20; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold Application level tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API and Gold Application level tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier and Gold Application level tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:21 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier and Gold Application level tier"));
    }

    @Test(groups={"wso2.am"}, description="test  invocation of  api under API tier Gold  and Application Tire Silver.Change the Application tire to silver and test ", dependsOnMethods={"testInvokingWithAPIGoldTierApplicationGold"})
    public void testInvokingWithAPIGoldTierApplicationSilverFor2ndTime() throws Exception, InterruptedException, IOException {
        long currentTime;
        this.applicationNameSilver = "ChangeApplicationTierAndTestInvokingTestCaseSilver";
        this.apiStoreClientUser1.updateApplication(this.applicationNameGold, this.applicationNameSilver, "", "", "Silver");
        Thread.sleep(65000L);
        long startTime = System.currentTimeMillis();
        for (int invocationCount = 1; invocationCount <= 5; ++invocationCount) {
            currentTime = System.currentTimeMillis();
            HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
            Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response code mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API  and Gold Application level tier"));
            Assert.assertTrue((boolean)invokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched. Invocation attempt:" + invocationCount + " failed  during :" + (currentTime - startTime) + " milliseconds under Gold API and Gold Application level tier"));
        }
        currentTime = System.currentTimeMillis();
        HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        HttpResponse invokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeApplicationTierAndTestInvoking", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)invokeResponse.getResponseCode(), (int)429, (String)("Response code mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier and Gold Application level tier"));
        Assert.assertTrue((boolean)invokeResponse.getData().contains("<amt:code>900800</amt:code><amt:message>Message throttled out</amt:message><amt:description>You have exceeded your quota</amt:description>"), (String)("Response data mismatched. Invocation attempt:6 passed  during :" + (currentTime - startTime) + " milliseconds under Gold API level tier and Gold Application level tier"));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeAPISubscriptionByApplicationName("ChangeApplicationTierAndTestInvokingTest", "1.0.0", this.providerName, this.applicationNameSilver);
        this.apiStoreClientUser1.removeApplication(this.applicationNameSilver);
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

