/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class EditAPIContextAndCheckAccessibilityTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "EditAPIContextAndCheckAccessibilityTest";
    private final String API_CONTEXT = "EditAPIContextAndCheckAccessibility";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "EditAPIContextAndCheckAccessibilityTestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIIdentifier apiIdentifier;
    private Map<String, String> requestHeaders;
    private APICreationRequestBean apiCreationRequestBean;
    private String newContext;
    private String applicationId = null;
    private String apiId;
    private String consumerKey;
    private String consumerSecret;
    private String userAccessToken;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException, ApiException {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("EditAPIContextAndCheckAccessibilityTest", "EditAPIContextAndCheckAccessibility", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiIdentifier = new APIIdentifier(this.providerName, "EditAPIContextAndCheckAccessibilityTest", "1.0.0");
        HttpResponse applicationResponse = this.restAPIStore.createApplication("EditAPIContextAndCheckAccessibilityTestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Test invoke the API before the context change")
    public void testInvokeAPIBeforeChangeAPIContext() throws Exception {
        APIRequest apiRequest = new APIRequest("EditAPIContextAndCheckAccessibilityTest", "EditAPIContextAndCheckAccessibility", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        APIOperationsDTO apiOperationsDTO2 = new APIOperationsDTO();
        apiOperationsDTO2.setVerb("GET");
        apiOperationsDTO2.setTarget("/customers/{id}");
        apiOperationsDTO2.setAuthType("Application & Application User");
        apiOperationsDTO2.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        operationsDTOS.add(apiOperationsDTO2);
        apiRequest.setOperationsDTOS(operationsDTOS);
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        this.userAccessToken = applicationKeyDTO.getToken().getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + this.userAccessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiIdentifier.getApiName(), this.apiIdentifier.getVersion(), "\"isApiExists\":true");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("EditAPIContextAndCheckAccessibility", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before change the context");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before change the context Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test changing of the API context", dependsOnMethods={"testInvokeAPIBeforeChangeAPIContext"})
    public void testEditAPIContext() throws APIManagerIntegrationTestException, MalformedURLException, org.wso2.am.integration.clients.publisher.api.ApiException {
        this.newContext = "newEditAPIContextAndCheckAccessibility";
        APIRequest apiBean = new APIRequest("EditAPIContextAndCheckAccessibilityTest", this.newContext, new URL(this.apiEndPointUrl));
        apiBean.setVersion("1.0.0");
        this.apiCreationRequestBean.setDescription("update This is test API create by API manager integration test");
        HttpResponse updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apiBean, this.apiId);
        Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of API using new context after Context change", dependsOnMethods={"testInvokeAPIAfterChangeAPIContextWithOldContext"})
    public void testInvokeAPIAfterChangeAPIContextWithNewContext() throws Exception {
        this.waitForAPIDeployment();
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(this.newContext, "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_NOT_FOUND, (String)"Response code mismatched when invoke api before changing the context");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<am:code>404</am:code><am:type>Status report</am:type><am:message>Not Found</am:message>"), (String)("Response data mismatched when invoke  API  before changing the context Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of API using old context after Context change after the API context change", dependsOnMethods={"testEditAPIContext"})
    public void testInvokeAPIAfterChangeAPIContextWithOldContext() throws Exception {
        this.waitForAPIDeployment();
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("EditAPIContextAndCheckAccessibility", "1.0.0") + "/" + "customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api after changing the context");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  after changing the context Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

