/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.apiproduct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.ApiProductTestHelper;
import org.wso2.am.integration.test.impl.ApiTestHelper;
import org.wso2.am.integration.test.impl.InvocationStatusCodes;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIProductCreationTestCase
extends APIManagerLifecycleBaseTest {
    private static final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private static final String RESTRICTED_SUBSCRIBER = "restricted_user";
    private static final String STANDARD_SUBSCRIBER = "standard_user";
    private static final String PASSWORD = "$3213#@sd";
    private static final String RESTRICTED_ROLE = "restricted_role";
    private static final String SCOPE = "restricted_scope";
    private ApiTestHelper apiTestHelper;
    private ApiProductTestHelper apiProductTestHelper;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.apiTestHelper = new ApiTestHelper(this.restAPIPublisher, this.restAPIStore, this.getAMResourceLocation(), this.keyManagerContext.getContextTenant().getDomain(), this.gatewayUrlsWrk.getWebAppURLNhttp());
        this.apiProductTestHelper = new ApiProductTestHelper(this.restAPIPublisher, this.restAPIStore);
        this.userManagementClient.addRole(RESTRICTED_ROLE, null, null);
        if (this.userManagementClient.userNameExists(INTERNAL_ROLE_SUBSCRIBER, RESTRICTED_SUBSCRIBER)) {
            this.userManagementClient.deleteUser(RESTRICTED_SUBSCRIBER);
        }
        this.userManagementClient.addUser(RESTRICTED_SUBSCRIBER, PASSWORD, new String[]{INTERNAL_ROLE_SUBSCRIBER, RESTRICTED_ROLE}, null);
        if (this.userManagementClient.userNameExists(INTERNAL_ROLE_SUBSCRIBER, STANDARD_SUBSCRIBER)) {
            this.userManagementClient.deleteUser(STANDARD_SUBSCRIBER);
        }
        this.userManagementClient.addUser(STANDARD_SUBSCRIBER, PASSWORD, new String[]{INTERNAL_ROLE_SUBSCRIBER}, null);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product")
    public void testCreateAndInvokeApiProduct() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createApiOne(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        apisToBeUsed.add(this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        org.wso2.am.integration.clients.store.api.v1.dto.APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on a visibility restricted API")
    public void testCreateAndInvokeApiProductWithVisibilityRestrictedApi() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        apisToBeUsed.add(this.apiTestHelper.createRestrictedAccessControlApi(this.getBackendEndServiceEndPointHttp("wildcard/resources"), RESTRICTED_ROLE));
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        org.wso2.am.integration.clients.store.api.v1.dto.APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on a scope protected API")
    public void testCreateAndInvokeApiProductWithScopes() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        apisToBeUsed.add(this.apiTestHelper.createScopeProtectedApi(this.getBackendEndServiceEndPointHttp("wildcard/resources"), RESTRICTED_ROLE, SCOPE));
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        org.wso2.am.integration.clients.store.api.v1.dto.APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        invocationStatusCodes.addScopeSpecificStatusCode(SCOPE, 403);
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.singletonList(SCOPE));
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.singletonList(SCOPE));
        invocationStatusCodes.addScopeSpecificStatusCode(SCOPE, 200);
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on an API with an in mediation sequence")
    public void testCreateAndInvokeApiProductWithInMediationApi() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createInMediationSequenceApi(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        org.wso2.am.integration.clients.store.api.v1.dto.APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        String requestBody = "{ \"foo\" : \"bar\" }";
        String expectedResponse = "<jsonObject><foo>bar</foo></jsonObject>";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes, requestBody, expectedResponse, headers);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, requestBody, expectedResponse, headers);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on an API with an out mediation sequence")
    public void testCreateAndInvokeApiProductWithOutMediationApi() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createOutMediationSequenceApi(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        org.wso2.am.integration.clients.store.api.v1.dto.APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        String requestBody = "<foo>bar</foo>";
        String expectedResponse = "{\"text\":\"<foo>bar</foo>\"}";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes, requestBody, expectedResponse, headers);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, requestBody, expectedResponse, headers);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        super.cleanUp();
        this.userManagementClient.deleteUser(RESTRICTED_SUBSCRIBER);
        this.userManagementClient.deleteUser(STANDARD_SUBSCRIBER);
        this.userManagementClient.deleteRole(RESTRICTED_ROLE);
    }
}

