/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyReGenerateResponseDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class ApplicationConsumerSecretRegenerateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(ApplicationConsumerSecretRegenerateTestCase.class);
    private final String APP_NAME = "CallBackUrlUpdateTestApp";
    private final String APP_DESCRIPTION = "description";
    private final String APP_CALLBACK_URL = "http://wso2.com/";
    private String consumerKey;
    private String consumerSecret;
    private RestAPIStoreImpl restAPIStore;
    private String applicationID;

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationConsumerSecretRegenerateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.restAPIStore = new RestAPIStoreImpl(this.user.getUserName(), this.user.getPassword(), this.publisherContext.getContextTenant().getDomain(), this.storeUrls.getWebAppURLHttps());
    }

    @Test(groups={"wso2.am"}, description="Sample Application creation")
    public void testApplicationCreation() throws Exception {
        ApplicationDTO application = this.restAPIStore.addApplication("CallBackUrlUpdateTestApp", "50PerMin", "http://wso2.com/", "description");
        this.applicationID = application.getApplicationId();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        ApplicationKeyDTO generatedKeys = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.consumerKey = generatedKeys.getConsumerKey();
        this.consumerSecret = generatedKeys.getConsumerSecret();
        Assert.assertNotNull((Object)this.consumerKey, (String)"Error in generating keys for application: CallBackUrlUpdateTestApp");
    }

    @Test(groups={"wso2.am"}, description="Test regenerate consumer secret after application key generate", dependsOnMethods={"testApplicationCreation"})
    public void testRegenerateConsumerSecret() throws Exception {
        ApiResponse regenerateResponse = this.restAPIStore.regenerateConsumerSecret(this.applicationID, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        Assert.assertEquals((int)regenerateResponse.getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)("Error when re-generating consumer secret for application: " + this.applicationID));
        Assert.assertNotNull((Object)((ApplicationKeyReGenerateResponseDTO)regenerateResponse.getData()).getConsumerSecret());
        Assert.assertNotEquals((Object)this.consumerSecret, (Object)((ApplicationKeyReGenerateResponseDTO)regenerateResponse.getData()).getConsumerSecret());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

