/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ApplicationTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ApplicationTestCase.class);
    private static final String webApp = "jaxrs_basic";
    private final String version = "1.0.0";
    private final String visibility = "public";
    private final String description = "API subscription";
    private final String tier = "Unlimited";
    private final String keyType = "PRODUCTION";
    private final String tags = "subscription";
    private final String applicationName = "NewApplicationTest";
    private final String newApplicationName = "UpdatedApplicationTest";
    private final String endPointType = "http";
    private String apiName = "SubscriptionAPITest";
    private String apiContext = "subscriptionapicontext";
    private String applicationId;
    private String apiId;
    private ArrayList<String> grantTypes;
    private ApplicationDTO applicationDTO;

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        this.grantTypes = new ArrayList();
        String uri = "customers/{id}/";
        String endpoint = "/services/customers/customerservice";
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + webApp + endpoint;
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setTarget(uri);
        apiOperationsDTOS.add(apiOperationsDTO);
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(endpointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(providerName);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setOperationsDTOS(apiOperationsDTOS);
        apiRequest.setEndpointType("http");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTags("subscription");
        apiRequest.setDescription("API subscription");
        apiRequest.setVisibility("public");
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        HttpResponse applicationResponse = this.restAPIStore.createApplication("NewApplicationTest", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        this.grantTypes.add("client_credentials");
    }

    @Test(groups={"webapp"}, description="Get Application By Application Id")
    public void testGetApplicationById() throws Exception {
        this.applicationDTO = this.restAPIStore.getApplicationById(this.applicationId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)this.applicationDTO.getApplicationId()), (String)"Adding application failed");
    }

    @Test(groups={"webapp"}, description="Application Key Generation By Application Id", dependsOnMethods={"testGetApplicationById"})
    public void testApplicationKeyGenerationById() throws Exception {
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
    }

    @Test(groups={"webapp"}, description="Update Client Application By Application Id", dependsOnMethods={"testApplicationKeyGenerationById"})
    public void testUpdateApplicationById() throws Exception {
        String callbackUrl = "test-callback";
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        this.applicationDTO.setApplicationId(this.applicationId);
        this.applicationDTO.setName("UpdatedApplicationTest");
        ApplicationKeyDTO applicationKeyDTO = new ApplicationKeyDTO();
        applicationKeyDTO.setKeyType(ApplicationKeyDTO.KeyTypeEnum.PRODUCTION);
        applicationKeyDTO.setCallbackUrl(callbackUrl);
        applicationKeyDTO.setSupportedGrantTypes(grantTypes);
        ArrayList<ApplicationKeyDTO> applicationKeyDTOS = new ArrayList<ApplicationKeyDTO>();
        applicationKeyDTOS.add(applicationKeyDTO);
        this.applicationDTO.setKeys(applicationKeyDTOS);
        HttpResponse updateResponse = this.restAPIStore.updateClientApplicationById(this.applicationId, this.applicationDTO);
        Assert.assertEquals((int)updateResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when adding an application");
        Gson gsonObject = new Gson();
        ApplicationDTO applicationDTOResponse = (ApplicationDTO)gsonObject.fromJson(updateResponse.getData(), ApplicationDTO.class);
        Assert.assertEquals((String)applicationDTOResponse.getName(), (String)"UpdatedApplicationTest", (String)"Application has not been updated");
    }

    @Test(groups={"webapp"}, description="Add subscription By Application Id", dependsOnMethods={"testUpdateApplicationById"})
    public void testAddSubscriptionApplicationById() throws Exception {
        HttpResponse subscriptionResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Unlimited", this.restAPIStore);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when adding an application");
    }

    @Test(groups={"webapp"}, description="Add subscription By Application Id", dependsOnMethods={"testUpdateApplicationById"})
    public void testGetSubscriptionForApplicationById() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        boolean isApiAvailable = false;
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            if (!this.apiId.equals(subscriptionDTO.getApiId())) continue;
            isApiAvailable = true;
            break;
        }
        Assert.assertTrue((boolean)isApiAvailable, (String)"Response Error in Api");
    }

    @Test(groups={"webapp"}, description="Add subscription By Application Id", dependsOnMethods={"testGetSubscriptionForApplicationById"})
    public void testCleanupApplicationRegistrationById() throws Exception {
        HttpResponse cleanupAppResponse = this.restAPIStore.cleanUpApplicationRegistrationByApplicationId(this.applicationId, "PRODUCTION");
        Assert.assertEquals((int)cleanupAppResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when cleaning up an application");
    }

    @Test(groups={"webapp"}, description="Remove application By Application Id", dependsOnMethods={"testCleanupApplicationRegistrationById"})
    public void testRemoveApplicationById() {
        HttpResponse removeAppResponse = this.restAPIStore.deleteApplication(this.applicationId);
        Assert.assertEquals((int)removeAppResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when deleting an application");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

