/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class GrantTypeTokenGenerateTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(GrantTypeTokenGenerateTestCase.class);
    private final String API_NAME = "GrantTypeTokenGenerateAPIName";
    private final String API_CONTEXT = "GrantTypeTokenGenerateContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "GrantTypeTokenGenerateApp";
    private final String CALLBACK_URL_UPDATE_APP_NAME = "GrantTypeTokenGenerateCallbackApp";
    private final String CALLBACK_URL = "https://localhost:9443/store/";
    private final String TAGS = "grantType,implicitly,code";
    private final String APPLICATION_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final String LOCATION_HEADER = "Location";
    private final String AUTHORIZATION_CODE_GRANT_TYPE = "authorization_code";
    private final String TIER_COLLECTION = "Unlimited";
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String consumerKey;
    private String consumerSecret;
    private String authorizeURL;
    private String tokenURL;
    private String identityLoginURL;
    private String apiId;
    private String applicationId;
    private String applicationIdWithoutCallback;
    private List<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
    private Map<String, String> headers = new HashMap<String, String>();
    private ArrayList<String> grantTypes = new ArrayList();
    private APIRequest apiRequest;

    @Factory(dataProvider="userModeDataProvider")
    public GrantTypeTokenGenerateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.authorizeURL = this.gatewayUrlsWrk.getWebAppURLNhttps() + "/authorize";
        this.tokenURL = this.gatewayUrlsWrk.getWebAppURLNhttps() + "/token";
        this.identityLoginURL = this.getKeyManagerURLHttps() + "/oauth2/authorize";
        HttpResponse applicationResponse = this.restAPIStore.createApplication("GrantTypeTokenGenerateApp", "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        String providerName = this.user.getUserName();
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("20KPerMin");
        apiOperationsDTO.setTarget("/add");
        apiOperationsDTOS.add(apiOperationsDTO);
        this.apiRequest = new APIRequest("GrantTypeTokenGenerateAPIName", "GrantTypeTokenGenerateContext", new URL(this.endpointUrl));
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setProvider(providerName);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTier("Unlimited");
        this.apiRequest.setOperationsDTOS(apiOperationsDTOS);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTags("grantType,implicitly,code");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(this.apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        this.grantTypes.add("client_credentials");
        this.grantTypes.add("authorization_code");
        this.grantTypes.add("password");
        this.grantTypes.add("refresh_token");
        this.grantTypes.add("urn:ietf:params:oauth:grant-type:saml2-bearer");
        this.grantTypes.add("iwa:ntlm");
        this.grantTypes.add("urn:ietf:params:oauth:grant-type:jwt-bearer");
        this.grantTypes.add("implicit");
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation")
    public void testApplicationCreation() throws Exception {
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", "https://localhost:9443/store/", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
    }

    @Test(groups={"wso2.am"}, description="Test authorization_code token generation", dependsOnMethods={"testApplicationCreation"})
    public void testAuthCode() throws Exception {
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        String url = this.authorizeURL + "?response_type=code&client_id=" + this.consumerKey + "&scope=PRODUCTION&redirect_uri=" + "https://localhost:9443/store/";
        HttpResponse res = HTTPSClientUtils.doGet((String)url, this.headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKey = this.getURLParameter(locationHeader, "sessionDataKey");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKey from the Location Header");
        this.headers.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("username", this.user.getUserName()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("password", this.user.getPassword()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("tocommonauth", "true"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKey", sessionDataKey));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKeyConsent = this.getURLParameter(locationHeader, "sessionDataKeyConsent");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKeyConsent from the Location Header");
        this.headers.clear();
        this.urlParameters.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("consent", "approve"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("hasApprovedAlways", "false"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKeyConsent", sessionDataKeyConsent));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String tempCode = this.getURLParameter(locationHeader, "code");
        Assert.assertNotNull((Object)tempCode, (String)"Couldn't found auth code from the Location Header");
        this.headers.clear();
        this.urlParameters.clear();
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("code", tempCode));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", "https://localhost:9443/store/"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("client_secret", this.consumerSecret));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("client_id", this.consumerKey));
        res = HTTPSClientUtils.doPost((String)this.tokenURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
        JSONObject response = new JSONObject(res.getData());
        String accessToken = response.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't found accessToken");
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("GrantTypeTokenGenerateContext", "1.0.0");
        res = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Test implicit token generation", dependsOnMethods={"testAuthCode"})
    public void testImplicit() throws Exception {
        this.headers.clear();
        this.urlParameters.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        String url = this.authorizeURL + "?response_type=token&client_id=" + this.consumerKey + "&scope=PRODUCTION&redirect_uri=" + "https://localhost:9443/store/";
        HttpResponse res = HTTPSClientUtils.doGet((String)url, this.headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKey = this.getURLParameter(locationHeader, "sessionDataKey");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKey from the Location Header");
        this.headers.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("username", this.user.getUserName()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("password", this.user.getPassword()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("tocommonauth", "true"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKey", sessionDataKey));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKeyConsent = this.getURLParameter(locationHeader, "sessionDataKeyConsent");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKeyConsent from the Location Header");
        this.headers.clear();
        this.urlParameters.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("consent", "approve"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("hasApprovedAlways", "false"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKeyConsent", sessionDataKeyConsent));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String accessToken = this.getURLParameter(locationHeader, "access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't found auth code from the Location Header");
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("GrantTypeTokenGenerateContext", "1.0.0");
        res = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation without callback URL", dependsOnMethods={"testImplicit"}, expectedExceptions={ApiException.class})
    public void testApplicationCreationWithoutCallBackURL() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication("GrantTypeTokenGenerateCallbackApp", "Test Application", APIThrottlingTier.UNLIMITED.getState(), ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationIdWithoutCallback = applicationResponse.getData();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationIdWithoutCallback, "Unlimited", this.restAPIStore);
        Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)subscribeResponse.getData()), (String)("Error in subscribe of old API version" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        ApiResponse response = this.restAPIStore.generateKeysWithApiResponse(this.applicationIdWithoutCallback, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes, Collections.emptyMap(), null);
        Assert.assertEquals((int)response.getStatusCode(), (int)HTTP_RESPONSE_CODE_BAD_REQUEST, (String)"Test Application Creation without callback URL not successful");
    }

    @Test(groups={"wso2.am"}, description="Test authorization_code token generation", dependsOnMethods={"testApplicationCreationWithoutCallBackURL"})
    public void testAuthRequestWithoutCallbackURL() throws Exception {
        this.headers.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        String url = this.authorizeURL + "?response_type=code&client_id=" + this.consumerKey + "&scope=PRODUCTION&redirect_uri=";
        HttpResponse res = HTTPSClientUtils.doGet((String)url, this.headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        Assert.assertTrue((boolean)locationHeader.contains("oauthErrorCode"), (String)"Redirection page should be a error page");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIStore.deleteApplication(this.applicationIdWithoutCallback);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private String getURLParameter(String url, String attribute) {
        try {
            Pattern p = Pattern.compile(attribute + "=([^&]+)");
            Matcher m = p.matcher(url);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }
}

