/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application.groupSharing;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.UserManagementUtils;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ApplicationSharingTestCase
extends APIMIntegrationBaseTest {
    private static final String APPLICATION_NAME = "TestApplication";
    private static final String USER_ONE = "userOne";
    private static final String USER_TWO = "userTwo";
    private static final String PASSWORD = "test@123";
    private static final String FIRST_NAME = "John";
    private static final String LAST_NAME = "Doe";
    private static final String EMAIL = "john.doe@test.com";
    private static final String ORGANIZATION = "Test";
    private String userOneApplicationId;
    private String userTwoApplicationId;
    private RestAPIStoreImpl restAPIStoreClientUser1;
    private RestAPIStoreImpl restAPIStoreClientUser2;
    private static final Log log = LogFactory.getLog(ApplicationSharingTestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationSharingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.createUsersAndApplications();
    }

    @Test(groups={"wso2.am"}, description="Remove user one's application and check if user two's application also is getting deleted")
    public void testUserTwoApplicationRemoval() throws Exception {
        this.restAPIStoreClientUser1.removeApplicationById(this.userOneApplicationId);
        List user2AllAppsList = this.restAPIStoreClientUser2.getAllApps().getList();
        boolean isUserTwoAppDeleted = user2AllAppsList.stream().noneMatch(applicationInfoDTO -> this.userTwoApplicationId.equals(applicationInfoDTO.getApplicationId()));
        Assert.assertFalse((boolean)isUserTwoAppDeleted, (String)"Deletion of User One's application has deleted User Two's application too");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStoreClientUser2.removeApplicationById(this.userTwoApplicationId);
        super.cleanUp();
    }

    private void createUsersAndApplications() throws Exception {
        UserManagementUtils.signupUser((String)USER_ONE, (String)PASSWORD, (String)FIRST_NAME, (String)ORGANIZATION);
        UserManagementUtils.signupUser((String)USER_TWO, (String)PASSWORD, (String)FIRST_NAME, (String)ORGANIZATION);
        this.restAPIStoreClientUser1 = new RestAPIStoreImpl(USER_ONE, PASSWORD, "carbon.super", this.storeURLHttps);
        this.restAPIStoreClientUser2 = new RestAPIStoreImpl(USER_TWO, PASSWORD, "carbon.super", this.storeURLHttps);
        HttpResponse appCreationResponse1 = this.restAPIStoreClientUser1.createApplication(APPLICATION_NAME, "App created by user1", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.userOneApplicationId = appCreationResponse1.getData();
        HttpResponse appCreationResponse2 = this.restAPIStoreClientUser2.createApplication(APPLICATION_NAME, "App created by user2", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.userTwoApplicationId = appCreationResponse2.getData();
    }
}

