/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.graphqlqueryanalysis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.RequestCountLimitDTO;
import org.wso2.am.integration.clients.admin.api.dto.SubscriptionThrottlePolicyDTO;
import org.wso2.am.integration.clients.admin.api.dto.ThrottleLimitDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLCustomComplexityInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLQueryComplexityInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaTypeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaTypeListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class GraphQLQueryAnalysisTest
extends APIMIntegrationBaseTest {
    private AdminDashboardRestClient adminDashboardRestClient;
    private RestAPIAdminImpl restAPIAdminUser;
    private final String GRAPHQL_API_NAME = "CountriesGraphqlAPIQueryAnalysis";
    private final String API_CONTEXT = "infoS";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String END_POINT_URL = "https://localhost:9943/am-graphQL-sample/api/graphql/";
    private String schemaDefinition;
    private String graphqlApiId;
    private String tokenTestApiAppId;
    private String oauthTokenTestApiId;

    @Factory(dataProvider="userModeDataProvider")
    public GraphQLQueryAnalysisTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminDashboardRestClient = new AdminDashboardRestClient(this.getPublisherURLHttps());
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO = new SubscriptionThrottlePolicyDTO();
        this.createNewSubscriptionPolicyObject(subscriptionThrottlePolicyDTO);
        this.restAPIAdminUser = new RestAPIAdminImpl("admin", "admin", "carbon.super", this.adminURLHttps);
        ApiResponse response = this.restAPIAdminUser.addSubscriptionThrottlingPolicy(subscriptionThrottlePolicyDTO);
        Assert.assertEquals((int)response.getStatusCode(), (int)201);
        this.schemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "schema.graphql"), (String)"UTF-8");
        File file = this.getTempFileWithContent(this.schemaDefinition);
        GraphQLValidationResponseDTO responseApiDto = this.restAPIPublisher.validateGraphqlSchemaDefinition(file);
        GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = responseApiDto.getGraphQLInfo();
        String arrayToJson = new ObjectMapper().writeValueAsString((Object)graphQLInfo.getOperations());
        JSONArray operations = new JSONArray(arrayToJson);
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Production and Sandbox");
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("Platinum");
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("name", (Object)"CountriesGraphqlAPIQueryAnalysis");
        additionalPropertiesObj.put("context", (Object)"infoS");
        additionalPropertiesObj.put("version", (Object)"1.0.0");
        JSONObject url = new JSONObject();
        url.put("url", (Object)"https://localhost:9943/am-graphQL-sample/api/graphql/");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("sandbox_endpoints", (Object)url);
        endpointConfig.put("production_endpoints", (Object)url);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        additionalPropertiesObj.put("gatewayEnvironments", environment);
        additionalPropertiesObj.put("policies", policies);
        additionalPropertiesObj.put("operations", (Object)operations);
        APIDTO apidto = this.restAPIPublisher.importGraphqlSchemaDefinition(file, additionalPropertiesObj.toString());
        this.graphqlApiId = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlApiId);
        System.out.println(createdApiResponse.getData());
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"CountriesGraphqlAPIQueryAnalysis API creation is failed");
        this.restAPIPublisher.changeAPILifeCycleStatus(this.graphqlApiId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "CountriesGraphqlAPIQueryAnalysis", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Add GraphQL Complexity Values in Publisher Portal")
    public void testAddGraphQLComplexity() throws Exception {
        GraphQLSchemaTypeListDTO graphQLSchemaTypeList = this.restAPIPublisher.getGraphQLSchemaTypeList(this.graphqlApiId);
        HttpResponse response = this.restAPIPublisher.getGraphQLSchemaTypeListResponse(this.graphqlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getResponseCode());
        List list = graphQLSchemaTypeList.getTypeList();
        System.out.println(list);
        ArrayList<GraphQLCustomComplexityInfoDTO> complexityList = new ArrayList<GraphQLCustomComplexityInfoDTO>();
        for (GraphQLSchemaTypeDTO graphQLSchemaTypeDTO : list) {
            List fieldList = graphQLSchemaTypeDTO.getFieldList();
            for (String field : fieldList) {
                GraphQLCustomComplexityInfoDTO graphQLCustomComplexityInfoDTO = new GraphQLCustomComplexityInfoDTO();
                graphQLCustomComplexityInfoDTO.setType(graphQLSchemaTypeDTO.getType());
                graphQLCustomComplexityInfoDTO.setField(field);
                graphQLCustomComplexityInfoDTO.setComplexityValue(Integer.valueOf(1));
                System.out.println(graphQLCustomComplexityInfoDTO);
                complexityList.add(graphQLCustomComplexityInfoDTO);
            }
        }
        GraphQLQueryComplexityInfoDTO graphQLQueryComplexityInfoDTO = new GraphQLQueryComplexityInfoDTO();
        graphQLQueryComplexityInfoDTO.setList(complexityList);
        this.restAPIPublisher.addGraphQLComplexityDetails(graphQLQueryComplexityInfoDTO, this.graphqlApiId);
        HttpResponse complexityResponse = this.restAPIPublisher.getGraphQLComplexityResponse(this.graphqlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)complexityResponse.getResponseCode());
    }

    @Test(groups={"wso2.am"}, description="View GraphQL Complexity Values in Developer Portal")
    public void testRetrieveGraphQLComplexity() throws Exception {
        HttpResponse complexityResponse = this.restAPIStore.getGraphQLComplexityResponse(this.graphqlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)complexityResponse.getResponseCode());
        HttpResponse response = this.restAPIStore.getGraphQLSchemaTypeListResponse(this.graphqlApiId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getResponseCode());
    }

    @Test(groups={"wso2.am"}, description="API invocation using JWT App")
    public void testInvokeGraphqlAPIUsingJWTApplication() throws Exception {
        String graphqlOAUTHAppName = "CountriesJWTAPPForQueryAnalysis";
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType(graphqlOAUTHAppName, "Unlimited", "", "test-app for JWT", "JWT");
        this.tokenTestApiAppId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.graphqlApiId, applicationDTO.getApplicationId(), "Platinum");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Platinum"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("infoS", "1.0.0") + "/";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        JSONObject queryObject = new JSONObject();
        queryObject.put("query", (Object)"{languages{code name native rtl}}");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)400);
        JSONObject queryObject2 = new JSONObject();
        queryObject2.put("query", (Object)"{countries{code name languages{code name}}}");
        HttpResponse serviceResponse2 = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject2.toString());
        Assert.assertEquals((int)serviceResponse2.getResponseCode(), (int)400);
    }

    @Test(groups={"wso2.am"}, description="API invocation using oauth App")
    public void testInvokeGraphqlAPIUsingOAuthApplication() throws Exception {
        String graphqlOAUTHAppName = "CountriesOauthAPPForQueryAnalysis";
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType(graphqlOAUTHAppName, "Unlimited", "", "test-app for OAUTH", "OAUTH");
        this.oauthTokenTestApiId = applicationDTO.getApplicationId();
        SubscriptionDTO subscriptionDTO = this.restAPIStore.subscribeToAPI(this.graphqlApiId, applicationDTO.getApplicationId(), "Platinum");
        Assert.assertEquals((boolean)true, (boolean)subscriptionDTO.getThrottlingPolicy().equals("Platinum"));
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationDTO.getApplicationId(), "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("infoS", "1.0.0") + "/";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        requestHeaders.put("Content-Type", "application/json");
        JSONObject queryObject = new JSONObject();
        queryObject.put("query", (Object)"{languages{code name native rtl}}");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)400);
        JSONObject queryObject2 = new JSONObject();
        queryObject2.put("query", (Object)"{countries{code name languages{code name}}}");
        HttpResponse serviceResponse2 = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject2.toString());
        Assert.assertEquals((int)serviceResponse2.getResponseCode(), (int)400);
    }

    public SubscriptionThrottlePolicyDTO createNewSubscriptionPolicyObject(SubscriptionThrottlePolicyDTO subscriptionThrottlePolicyDTO) {
        subscriptionThrottlePolicyDTO.setPolicyId("0c6439fd-9b16-3c2e-be6e-1086e0b9aa92");
        subscriptionThrottlePolicyDTO.setPolicyName("Platinum");
        subscriptionThrottlePolicyDTO.setDisplayName("Platinum");
        subscriptionThrottlePolicyDTO.setDescription("Platinum");
        subscriptionThrottlePolicyDTO.setRateLimitCount(Integer.valueOf(1000));
        subscriptionThrottlePolicyDTO.setRateLimitTimeUnit("min");
        subscriptionThrottlePolicyDTO.setBillingPlan("COMMERCIAL");
        subscriptionThrottlePolicyDTO.setStopOnQuotaReach(Boolean.valueOf(true));
        subscriptionThrottlePolicyDTO.setIsDeployed(Boolean.valueOf(true));
        subscriptionThrottlePolicyDTO.setGraphQLMaxComplexity(Integer.valueOf(4));
        subscriptionThrottlePolicyDTO.setGraphQLMaxDepth(Integer.valueOf(2));
        ThrottleLimitDTO throttleLimitDTO = new ThrottleLimitDTO();
        throttleLimitDTO.setType(ThrottleLimitDTO.TypeEnum.valueOf((String)"REQUESTCOUNTLIMIT"));
        RequestCountLimitDTO requestCountLimitDTO = new RequestCountLimitDTO();
        requestCountLimitDTO.setRequestCount(Long.valueOf(1000L));
        requestCountLimitDTO.setTimeUnit("min");
        requestCountLimitDTO.setUnitTime(Integer.valueOf(10));
        throttleLimitDTO.setRequestCount(requestCountLimitDTO);
        subscriptionThrottlePolicyDTO.setDefaultLimit(throttleLimitDTO);
        return subscriptionThrottlePolicyDTO;
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("schema", ".graphql");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.oauthTokenTestApiId);
        this.restAPIStore.deleteApplication(this.tokenTestApiAppId);
        this.restAPIPublisher.deleteAPI(this.graphqlApiId);
        super.cleanUp();
    }
}

