/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class CustomHeaderTestCase
extends APIManagerLifecycleBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private final String CUSTOM_AUTHORIZATION_HEADER = "Test-Custom-Header";
    private final String API1_NAME = "CustomAuthHeaderTestAPI1";
    private final String API1_CONTEXT = "customAuthHeaderTest1";
    private final String API1_VERSION = "1.0.0";
    private final String APPLICATION1_NAME = "CustomHeaderTest-Application";
    private final String API_END_POINT_METHOD = "customers/123";
    private final String API2_NAME = "CustomAuthHeaderTestAPI2";
    private final String API2_CONTEXT = "customAuthHeaderTest2";
    private final String API2_VERSION = "1.0.0";
    private String accessToken;
    private String applicationId;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public CustomHeaderTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "customHeaderTest" + File.separator + "deployment.toml"));
        HttpResponse applicationResponse = this.restAPIStore.createApplication("ApplicationTest", "50PerMin", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Set a customer Auth header for all APIs in the system. (Test ID: 3.1.1.5, 3.1.1.14)")
    public void testSystemWideCustomAuthHeader() throws Exception {
        APIIdentifier apiIdentifier1 = new APIIdentifier(this.user.getUserName(), "CustomAuthHeaderTestAPI1", "1.0.0");
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest("CustomAuthHeaderTestAPI1", "customAuthHeaderTest1", new URL(url), new URL(url));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.user.getUserName());
        apiRequest.setTiersCollection("Unlimited");
        String invocationUrl = this.getAPIInvocationURLHttps("customAuthHeaderTest1", "1.0.0") + "/" + "customers/123";
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "CustomAuthHeaderTestAPI1", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders1 = new HashMap<String, String>();
        requestHeaders1.put("accept", "application/json");
        requestHeaders1.put("Test-Custom-Header", "Bearer " + this.accessToken);
        HttpResponse apiResponse1 = HttpRequestUtil.doGet((String)invocationUrl, requestHeaders1);
        Assert.assertEquals((int)apiResponse1.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        HashMap<String, String> requestHeaders2 = new HashMap<String, String>();
        requestHeaders2.put("accept", "application/json");
        requestHeaders2.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse apiResponse2 = HttpRequestUtil.doGet((String)invocationUrl, requestHeaders2);
        Assert.assertEquals((int)apiResponse2.getResponseCode(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Response code mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO.getSubscriptionId());
        }
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration();
        }
    }
}

